/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Writer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultAttribute;

public abstract class AbstractAttribute
extends AbstractNode
implements Attribute {
    public short getNodeType() {
        return 2;
    }

    public void setNamespace(Namespace namespace) {
        String string = "This Attribute is read only and cannot be changed";
        throw new UnsupportedOperationException(string);
    }

    public String getText() {
        return this.getValue();
    }

    public void setText(String string) {
        this.setValue(string);
    }

    public void setValue(String string) {
        String string2 = "This Attribute is read only and cannot be changed";
        throw new UnsupportedOperationException(string2);
    }

    public Object getData() {
        return this.getValue();
    }

    public void setData(Object object) {
        this.setValue(object == null ? null : object.toString());
    }

    public String toString() {
        return super.toString() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\"]";
    }

    public String asXML() {
        return this.getQualifiedName() + "=\"" + this.getValue() + "\"";
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getQualifiedName());
        writer.write("=\"");
        writer.write(this.getValue());
        writer.write("\"");
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    public String getName() {
        return this.getQName().getName();
    }

    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    public String getPath(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element2 = this.getParent();
        if (element2 != null && element2 != element) {
            stringBuffer.append(element2.getPath(element));
            stringBuffer.append("/");
        }
        stringBuffer.append("@");
        String string = this.getNamespaceURI();
        String string2 = this.getNamespacePrefix();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            stringBuffer.append(this.getName());
        } else {
            stringBuffer.append(this.getQualifiedName());
        }
        return stringBuffer.toString();
    }

    public String getUniquePath(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element2 = this.getParent();
        if (element2 != null && element2 != element) {
            stringBuffer.append(element2.getUniquePath(element));
            stringBuffer.append("/");
        }
        stringBuffer.append("@");
        String string = this.getNamespaceURI();
        String string2 = this.getNamespacePrefix();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            stringBuffer.append(this.getName());
        } else {
            stringBuffer.append(this.getQualifiedName());
        }
        return stringBuffer.toString();
    }

    protected Node createXPathResult(Element element) {
        return new DefaultAttribute(element, this.getQName(), this.getValue());
    }
}

