/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.ElementModifier;
import org.dom4j.io.ElementStack;
import org.dom4j.io.SAXModifyException;

class SAXModifyElementHandler
implements ElementHandler {
    private ElementModifier elemModifier;
    private Element modifiedElement;

    public SAXModifyElementHandler(ElementModifier elementModifier) {
        this.elemModifier = elementModifier;
    }

    public void onStart(ElementPath elementPath) {
        this.modifiedElement = elementPath.getCurrent();
    }

    public void onEnd(ElementPath elementPath) {
        try {
            Object object;
            Element element = elementPath.getCurrent();
            Element element2 = element.getParent();
            if (element2 != null) {
                object = (Element)element.clone();
                this.modifiedElement = this.elemModifier.modifyElement((Element)object);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setParent(element.getParent());
                    this.modifiedElement.setDocument(element.getDocument());
                    int n = element2.indexOf(element);
                    element2.content().set(n, this.modifiedElement);
                }
                element.detach();
            } else if (element.isRootElement()) {
                object = (Element)element.clone();
                this.modifiedElement = this.elemModifier.modifyElement((Element)object);
                if (this.modifiedElement != null) {
                    this.modifiedElement.setDocument(element.getDocument());
                    Document document = element.getDocument();
                    document.setRootElement(this.modifiedElement);
                }
                element.detach();
            }
            if (elementPath instanceof ElementStack) {
                object = (ElementStack)elementPath;
                ((ElementStack)object).popElement();
                ((ElementStack)object).pushElement(this.modifiedElement);
            }
        }
        catch (Exception exception) {
            throw new SAXModifyException(exception);
        }
    }

    protected Element getModifiedElement() {
        return this.modifiedElement;
    }
}

