/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeDocumentFactory;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.NamedTypeResolver;
import org.dom4j.io.SAXReader;
import org.dom4j.util.AttributeHelper;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaParser {
    private static final Namespace XSD_NAMESPACE = Namespace.get("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ELEMENT = QName.get("element", XSD_NAMESPACE);
    private static final QName XSD_ATTRIBUTE = QName.get("attribute", XSD_NAMESPACE);
    private static final QName XSD_SIMPLETYPE = QName.get("simpleType", XSD_NAMESPACE);
    private static final QName XSD_COMPLEXTYPE = QName.get("complexType", XSD_NAMESPACE);
    private static final QName XSD_RESTRICTION = QName.get("restriction", XSD_NAMESPACE);
    private static final QName XSD_SEQUENCE = QName.get("sequence", XSD_NAMESPACE);
    private static final QName XSD_CHOICE = QName.get("choice", XSD_NAMESPACE);
    private static final QName XSD_ALL = QName.get("all", XSD_NAMESPACE);
    private static final QName XSD_INCLUDE = QName.get("include", XSD_NAMESPACE);
    private DatatypeDocumentFactory documentFactory;
    private Map dataTypeCache = new HashMap();
    private NamedTypeResolver namedTypeResolver;
    private Namespace targetNamespace;

    public SchemaParser() {
        this(DatatypeDocumentFactory.singleton);
    }

    public SchemaParser(DatatypeDocumentFactory datatypeDocumentFactory) {
        this.documentFactory = datatypeDocumentFactory;
        this.namedTypeResolver = new NamedTypeResolver(datatypeDocumentFactory);
    }

    public void build(Document document) {
        this.targetNamespace = null;
        this.internalBuild(document);
    }

    public void build(Document document, Namespace namespace) {
        this.targetNamespace = namespace;
        this.internalBuild(document);
    }

    private synchronized void internalBuild(Document document) {
        Element element = document.getRootElement();
        if (element != null) {
            Object object;
            Iterator iterator = element.elementIterator(XSD_INCLUDE);
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                String string = object.attributeValue("schemaLocation");
                EntityResolver entityResolver = document.getEntityResolver();
                try {
                    Object object2;
                    Object object3;
                    if (entityResolver == null) {
                        object3 = "No EntityResolver available";
                        throw new InvalidSchemaException((String)object3);
                    }
                    object3 = entityResolver.resolveEntity(null, string);
                    if (object3 == null) {
                        object2 = "Could not resolve the schema URI: " + string;
                        throw new InvalidSchemaException((String)object2);
                    }
                    object2 = new SAXReader();
                    Document document2 = ((SAXReader)object2).read((InputSource)object3);
                    this.build(document2);
                }
                catch (Exception exception) {
                    System.out.println("Failed to load schema: " + string);
                    System.out.println("Caught: " + exception);
                    exception.printStackTrace();
                    throw new InvalidSchemaException("Failed to load schema: " + string);
                }
            }
            object = element.elementIterator(XSD_ELEMENT);
            while (object.hasNext()) {
                this.onDatatypeElement((Element)object.next(), this.documentFactory);
            }
            object = element.elementIterator(XSD_SIMPLETYPE);
            while (object.hasNext()) {
                this.onNamedSchemaSimpleType((Element)object.next());
            }
            object = element.elementIterator(XSD_COMPLEXTYPE);
            while (object.hasNext()) {
                this.onNamedSchemaComplexType((Element)object.next());
            }
            this.namedTypeResolver.resolveNamedTypes();
        }
    }

    private void onDatatypeElement(Element element, DocumentFactory documentFactory) {
        Iterator iterator;
        Object object;
        String string = element.attributeValue("name");
        String string2 = element.attributeValue("type");
        QName qName = this.getQName(string);
        DatatypeElementFactory datatypeElementFactory = this.getDatatypeElementFactory(qName);
        if (string2 != null) {
            XSDatatype xSDatatype = this.getTypeByName(string2);
            if (xSDatatype != null) {
                datatypeElementFactory.setChildElementXSDatatype(qName, xSDatatype);
            } else {
                QName qName2 = this.getQName(string2);
                this.namedTypeResolver.registerTypedElement(element, qName2, documentFactory);
            }
            return;
        }
        Element element2 = element.element(XSD_SIMPLETYPE);
        if (element2 != null && (object = this.loadXSDatatypeFromSimpleType(element2)) != null) {
            datatypeElementFactory.setChildElementXSDatatype(qName, (XSDatatype)object);
        }
        if ((object = element.element(XSD_COMPLEXTYPE)) != null) {
            this.onSchemaComplexType((Element)object, datatypeElementFactory);
        }
        if ((iterator = element.elementIterator(XSD_ATTRIBUTE)).hasNext()) {
            do {
                this.onDatatypeAttribute(element, datatypeElementFactory, (Element)iterator.next());
            } while (iterator.hasNext());
        }
    }

    private void onNamedSchemaComplexType(Element element) {
        Attribute attribute = element.attribute("name");
        if (attribute == null) {
            return;
        }
        String string = attribute.getText();
        QName qName = this.getQName(string);
        DatatypeElementFactory datatypeElementFactory = this.getDatatypeElementFactory(qName);
        this.onSchemaComplexType(element, datatypeElementFactory);
        this.namedTypeResolver.registerComplexType(qName, datatypeElementFactory);
    }

    private void onSchemaComplexType(Element element, DatatypeElementFactory datatypeElementFactory) {
        Object object;
        Object object2;
        Element element2;
        Iterator iterator = element.elementIterator(XSD_ATTRIBUTE);
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            object2 = element2.attributeValue("name");
            object = this.getQName((String)object2);
            XSDatatype xSDatatype = this.dataTypeForXsdAttribute(element2);
            if (xSDatatype == null) continue;
            datatypeElementFactory.setAttributeXSDatatype((QName)object, xSDatatype);
        }
        element2 = element.element(XSD_SEQUENCE);
        if (element2 != null) {
            this.onChildElements(element2, datatypeElementFactory);
        }
        if ((object2 = element.element(XSD_CHOICE)) != null) {
            this.onChildElements((Element)object2, datatypeElementFactory);
        }
        if ((object = element.element(XSD_ALL)) != null) {
            this.onChildElements((Element)object, datatypeElementFactory);
        }
    }

    private void onChildElements(Element element, DatatypeElementFactory datatypeElementFactory) {
        Iterator iterator = element.elementIterator(XSD_ELEMENT);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            this.onDatatypeElement(element2, datatypeElementFactory);
        }
    }

    private void onDatatypeAttribute(Element element, DatatypeElementFactory datatypeElementFactory, Element element2) {
        String string = element2.attributeValue("name");
        QName qName = this.getQName(string);
        XSDatatype xSDatatype = this.dataTypeForXsdAttribute(element2);
        if (xSDatatype != null) {
            datatypeElementFactory.setAttributeXSDatatype(qName, xSDatatype);
        } else {
            String string2 = element2.attributeValue("type");
            System.out.println("Warning: Couldn't find XSDatatype for type: " + string2 + " attribute: " + string);
        }
    }

    private XSDatatype dataTypeForXsdAttribute(Element element) {
        String string = element.attributeValue("type");
        XSDatatype xSDatatype = null;
        if (string != null) {
            xSDatatype = this.getTypeByName(string);
        } else {
            Element element2 = element.element(XSD_SIMPLETYPE);
            if (element2 == null) {
                String string2 = element.attributeValue("name");
                String string3 = "The attribute: " + string2 + " has no type attribute and does not contain a " + "<simpleType/> element";
                throw new InvalidSchemaException(string3);
            }
            xSDatatype = this.loadXSDatatypeFromSimpleType(element2);
        }
        return xSDatatype;
    }

    private void onNamedSchemaSimpleType(Element element) {
        Attribute attribute = element.attribute("name");
        if (attribute == null) {
            return;
        }
        String string = attribute.getText();
        QName qName = this.getQName(string);
        XSDatatype xSDatatype = this.loadXSDatatypeFromSimpleType(element);
        this.namedTypeResolver.registerSimpleType(qName, xSDatatype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XSDatatype loadXSDatatypeFromSimpleType(Element element) {
        Element element2 = element.element(XSD_RESTRICTION);
        if (element2 != null) {
            String string = element2.attributeValue("base");
            if (string != null) {
                XSDatatype xSDatatype = this.getTypeByName(string);
                if (xSDatatype != null) return this.deriveSimpleType(xSDatatype, element2);
                this.onSchemaError("Invalid base type: " + string + " when trying to build restriction: " + element2);
                return null;
            } else {
                Element element3 = element.element(XSD_SIMPLETYPE);
                if (element3 != null) return this.loadXSDatatypeFromSimpleType(element3);
                String string2 = "The simpleType element: " + element + " must contain a base attribute or simpleType" + " element";
                this.onSchemaError(string2);
            }
            return null;
        } else {
            this.onSchemaError("No <restriction>. Could not create XSDatatype for simpleType: " + element);
        }
        return null;
    }

    private XSDatatype deriveSimpleType(XSDatatype xSDatatype, Element element) {
        TypeIncubator typeIncubator = new TypeIncubator(xSDatatype);
        ValidationContext validationContext = null;
        try {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string = element2.getName();
                String string2 = element2.attributeValue("value");
                boolean bl = AttributeHelper.booleanValue(element2, "fixed");
                typeIncubator.addFacet(string, string2, bl, validationContext);
            }
            iterator = null;
            return typeIncubator.derive("", (String)((Object)iterator));
        }
        catch (DatatypeException datatypeException) {
            this.onSchemaError("Invalid restriction: " + datatypeException.getMessage() + " when trying to build restriction: " + element);
            return null;
        }
    }

    private DatatypeElementFactory getDatatypeElementFactory(QName qName) {
        DatatypeElementFactory datatypeElementFactory = this.documentFactory.getElementFactory(qName);
        if (datatypeElementFactory == null) {
            datatypeElementFactory = new DatatypeElementFactory(qName);
            qName.setDocumentFactory(datatypeElementFactory);
        }
        return datatypeElementFactory;
    }

    private XSDatatype getTypeByName(String string) {
        XSDatatype xSDatatype = (XSDatatype)this.dataTypeCache.get(string);
        if (xSDatatype == null) {
            Object object;
            int n = string.indexOf(58);
            if (n >= 0) {
                object = string.substring(n + 1);
                try {
                    xSDatatype = DatatypeFactory.getTypeByName((String)object);
                }
                catch (DatatypeException datatypeException) {
                    // empty catch block
                }
            }
            if (xSDatatype == null) {
                try {
                    xSDatatype = DatatypeFactory.getTypeByName((String)string);
                }
                catch (DatatypeException datatypeException) {
                    // empty catch block
                }
            }
            if (xSDatatype == null) {
                object = this.getQName(string);
                xSDatatype = (XSDatatype)this.namedTypeResolver.simpleTypeMap.get(object);
            }
            if (xSDatatype != null) {
                this.dataTypeCache.put(string, xSDatatype);
            }
        }
        return xSDatatype;
    }

    private QName getQName(String string) {
        if (this.targetNamespace == null) {
            return this.documentFactory.createQName(string);
        }
        return this.documentFactory.createQName(string, this.targetNamespace);
    }

    private void onSchemaError(String string) {
        throw new InvalidSchemaException(string);
    }
}

