/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.rule.Pattern;
import org.jaxen.VariableContext;
import org.xml.sax.InputSource;

public final class DocumentHelper {
    private DocumentHelper() {
    }

    private static DocumentFactory getDocumentFactory() {
        return DocumentFactory.getInstance();
    }

    public static Document createDocument() {
        return DocumentHelper.getDocumentFactory().createDocument();
    }

    public static Document createDocument(Element element) {
        return DocumentHelper.getDocumentFactory().createDocument(element);
    }

    public static Element createElement(QName qName) {
        return DocumentHelper.getDocumentFactory().createElement(qName);
    }

    public static Element createElement(String string) {
        return DocumentHelper.getDocumentFactory().createElement(string);
    }

    public static Attribute createAttribute(Element element, QName qName, String string) {
        return DocumentHelper.getDocumentFactory().createAttribute(element, qName, string);
    }

    public static Attribute createAttribute(Element element, String string, String string2) {
        return DocumentHelper.getDocumentFactory().createAttribute(element, string, string2);
    }

    public static CDATA createCDATA(String string) {
        return DocumentFactory.getInstance().createCDATA(string);
    }

    public static Comment createComment(String string) {
        return DocumentFactory.getInstance().createComment(string);
    }

    public static Text createText(String string) {
        return DocumentFactory.getInstance().createText(string);
    }

    public static Entity createEntity(String string, String string2) {
        return DocumentFactory.getInstance().createEntity(string, string2);
    }

    public static Namespace createNamespace(String string, String string2) {
        return DocumentFactory.getInstance().createNamespace(string, string2);
    }

    public static ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return DocumentHelper.getDocumentFactory().createProcessingInstruction(string, string2);
    }

    public static ProcessingInstruction createProcessingInstruction(String string, Map map) {
        return DocumentHelper.getDocumentFactory().createProcessingInstruction(string, map);
    }

    public static QName createQName(String string, Namespace namespace) {
        return DocumentHelper.getDocumentFactory().createQName(string, namespace);
    }

    public static QName createQName(String string) {
        return DocumentHelper.getDocumentFactory().createQName(string);
    }

    public static XPath createXPath(String string) throws InvalidXPathException {
        return DocumentHelper.getDocumentFactory().createXPath(string);
    }

    public static XPath createXPath(String string, VariableContext variableContext) throws InvalidXPathException {
        return DocumentHelper.getDocumentFactory().createXPath(string, variableContext);
    }

    public static NodeFilter createXPathFilter(String string) {
        return DocumentHelper.getDocumentFactory().createXPathFilter(string);
    }

    public static Pattern createPattern(String string) {
        return DocumentHelper.getDocumentFactory().createPattern(string);
    }

    public static List selectNodes(String string, List list) {
        XPath xPath = DocumentHelper.createXPath(string);
        return xPath.selectNodes(list);
    }

    public static List selectNodes(String string, Node node) {
        XPath xPath = DocumentHelper.createXPath(string);
        return xPath.selectNodes(node);
    }

    public static void sort(List list, String string) {
        XPath xPath = DocumentHelper.createXPath(string);
        xPath.sort(list);
    }

    public static void sort(List list, String string, boolean bl) {
        XPath xPath = DocumentHelper.createXPath(string);
        xPath.sort(list, bl);
    }

    public static Document parseText(String string) throws DocumentException {
        Document document = null;
        SAXReader sAXReader = new SAXReader();
        String string2 = DocumentHelper.getEncoding(string);
        InputSource inputSource = new InputSource(new StringReader(string));
        inputSource.setEncoding(string2);
        document = sAXReader.read(inputSource);
        if (document.getXMLEncoding() == null) {
            document.setXMLEncoding(string2);
        }
        return document;
    }

    private static String getEncoding(String string) {
        String string2 = null;
        String string3 = string.trim();
        if (string3.startsWith("<?xml")) {
            int n = string3.indexOf("?>");
            String string4 = string3.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " =\"'");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (!"encoding".equals(string5)) continue;
                if (!stringTokenizer.hasMoreTokens()) break;
                string2 = stringTokenizer.nextToken();
                break;
            }
        }
        return string2;
    }

    public static Element makeElement(Branch branch, String string) {
        String string2;
        Branch branch2;
        Branch branch3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (branch instanceof Document) {
            branch3 = (Document)branch;
            branch2 = branch3.getRootElement();
            string2 = stringTokenizer.nextToken();
            if (branch2 == null) {
                branch2 = branch3.addElement(string2);
            }
        } else {
            branch2 = (Element)branch;
        }
        branch3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            branch3 = string2.indexOf(58) > 0 ? branch2.element(branch2.getQName(string2)) : branch2.element(string2);
            if (branch3 == null) {
                branch3 = branch2.addElement(string2);
            }
            branch2 = branch3;
        }
        return branch3;
    }
}

