/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.siv.JceAesBlockCipher;
import org.cryptomator.siv.UnauthenticCiphertextException;
import org.cryptomator.siv.org.bouncycastle.crypto.BlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.Mac;
import org.cryptomator.siv.org.bouncycastle.crypto.macs.CMac;
import org.cryptomator.siv.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.cryptomator.siv.org.bouncycastle.crypto.params.KeyParameter;

public final class SivMode {
    private static final byte[] BYTES_ZERO = new byte[16];
    private static final byte DOUBLING_CONST = -121;
    private final ThreadLocal<BlockCipher> threadLocalCipher;

    public SivMode() {
        this(new BlockCipherFactory(){

            @Override
            public BlockCipher create() {
                return new JceAesBlockCipher();
            }
        });
    }

    public SivMode(final BlockCipherFactory blockCipherFactory) {
        if (blockCipherFactory.create().getBlockSize() != 16) {
            throw new IllegalArgumentException("cipherFactory must create BlockCipher objects with a 16-byte block size");
        }
        this.threadLocalCipher = new ThreadLocal<BlockCipher>(){

            @Override
            protected BlockCipher initialValue() {
                return blockCipherFactory.create();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(SecretKey secretKey, SecretKey secretKey2, byte[] byArray, byte[] ... byArray2) {
        byte[] byArray3 = secretKey.getEncoded();
        byte[] byArray4 = secretKey2.getEncoded();
        if (byArray3 == null || byArray4 == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray5 = this.encrypt(byArray3, byArray4, byArray, byArray2);
            return byArray5;
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
            Arrays.fill(byArray4, (byte)0);
        }
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] ... byArray4) {
        if (byArray3.length > 0x7FFFFFEF) {
            throw new IllegalArgumentException("Plaintext is too long");
        }
        assert (byArray3.length + 15 < Integer.MAX_VALUE);
        int n = (byArray3.length + 15) / 16;
        byte[] byArray5 = this.s2v(byArray2, byArray3, byArray4);
        byte[] byArray6 = this.generateKeyStream(byArray, byArray5, n);
        byte[] byArray7 = SivMode.xor(byArray3, byArray6);
        byte[] byArray8 = new byte[byArray5.length + byArray7.length];
        System.arraycopy(byArray5, 0, byArray8, 0, byArray5.length);
        System.arraycopy(byArray7, 0, byArray8, byArray5.length, byArray7.length);
        return byArray8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(SecretKey secretKey, SecretKey secretKey2, byte[] byArray, byte[] ... byArray2) throws UnauthenticCiphertextException, IllegalBlockSizeException {
        byte[] byArray3 = secretKey.getEncoded();
        byte[] byArray4 = secretKey2.getEncoded();
        if (byArray3 == null || byArray4 == null) {
            throw new IllegalArgumentException("Can't get bytes of given key.");
        }
        try {
            byte[] byArray5 = this.decrypt(byArray3, byArray4, byArray, byArray2);
            return byArray5;
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
            Arrays.fill(byArray4, (byte)0);
        }
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] ... byArray4) throws UnauthenticCiphertextException, IllegalBlockSizeException {
        if (byArray3.length < 16) {
            throw new IllegalBlockSizeException("Input length must be greater than or equal 16.");
        }
        byte[] byArray5 = Arrays.copyOf(byArray3, 16);
        byte[] byArray6 = Arrays.copyOfRange(byArray3, 16, byArray3.length);
        assert (byArray6.length == byArray3.length - 16);
        assert (byArray6.length + 15 < Integer.MAX_VALUE);
        int n = (byArray6.length + 15) / 16;
        byte[] byArray7 = this.generateKeyStream(byArray, byArray5, n);
        byte[] byArray8 = SivMode.xor(byArray6, byArray7);
        byte[] byArray9 = this.s2v(byArray2, byArray8, byArray4);
        assert (byArray5.length == byArray9.length);
        int n2 = 0;
        for (int i = 0; i < byArray5.length; ++i) {
            n2 |= byArray5[i] ^ byArray9[i];
        }
        if (n2 == 0) {
            return byArray8;
        }
        throw new UnauthenticCiphertextException("authentication in SIV decryption failed");
    }

    byte[] generateKeyStream(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[n * 16];
        byte[] byArray4 = Arrays.copyOf(byArray2, 16);
        byArray4[8] = (byte)(byArray4[8] & 0x7F);
        byArray4[12] = (byte)(byArray4[12] & 0x7F);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray4);
        long l = byteBuffer.getLong(8);
        BlockCipher blockCipher = this.threadLocalCipher.get();
        blockCipher.init(true, new KeyParameter(byArray));
        for (int i = 0; i < n; ++i) {
            byteBuffer.putLong(8, l + (long)i);
            blockCipher.processBlock(byArray4, 0, byArray3, i * 16);
            blockCipher.reset();
        }
        return byArray3;
    }

    byte[] s2v(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        if (byArray3.length > 126) {
            throw new IllegalArgumentException("too many Associated Data fields");
        }
        KeyParameter keyParameter = new KeyParameter(byArray);
        CMac cMac = new CMac(this.threadLocalCipher.get());
        cMac.init(keyParameter);
        byte[] byArray4 = SivMode.mac(cMac, BYTES_ZERO);
        for (byte[] byArray5 : byArray3) {
            byArray4 = SivMode.xor(SivMode.dbl(byArray4), SivMode.mac(cMac, byArray5));
        }
        Object object = byArray2.length >= 16 ? (Object)SivMode.xorend(byArray2, byArray4) : (Object)SivMode.xor(SivMode.dbl(byArray4), SivMode.pad(byArray2));
        return SivMode.mac(cMac, (byte[])object);
    }

    private static byte[] mac(Mac mac, byte[] byArray) {
        byte[] byArray2 = new byte[mac.getMacSize()];
        mac.update(byArray, 0, byArray.length);
        mac.doFinal(byArray2, 0);
        return byArray2;
    }

    private static byte[] pad(byte[] byArray) {
        byte[] byArray2 = Arrays.copyOf(byArray, 16);
        new ISO7816d4Padding().addPadding(byArray2, byArray.length);
        return byArray2;
    }

    static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = 0;
        while (--n >= 0) {
            int n3 = byArray[n] & 0xFF;
            byArray2[n] = (byte)(n3 << 1 | n2);
            n2 = n3 >>> 7 & 1;
        }
        return n2;
    }

    static byte[] dbl(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = SivMode.shiftLeft(byArray, byArray2);
        int n2 = 135;
        int n3 = -n & 0xFF;
        int n4 = byArray.length - 1;
        byArray2[n4] = (byte)(byArray2[n4] ^ n2 & n3);
        return byArray2;
    }

    static byte[] xor(byte[] byArray, byte[] byArray2) {
        assert (byArray.length <= byArray2.length) : "Length of first input must be <= length of second input.";
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    static byte[] xorend(byte[] byArray, byte[] byArray2) {
        assert (byArray.length >= byArray2.length) : "Length of first input must be >= length of second input.";
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length);
        int n = byArray.length - byArray2.length;
        for (int i = 0; i < byArray2.length; ++i) {
            byArray3[i + n] = (byte)(byArray3[i + n] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static interface BlockCipherFactory {
        public BlockCipher create();
    }
}

