/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public final class CipherSupplier {
    public static final CipherSupplier AES_CTR = new CipherSupplier("AES/CTR/NoPadding");
    public static final CipherSupplier RFC3394_KEYWRAP = new CipherSupplier("AESWrap");
    private final String cipherAlgorithm;
    private final ThreadLocal<Cipher> threadLocal;

    public CipherSupplier(String string) {
        this.cipherAlgorithm = string;
        this.threadLocal = new Provider();
        this.threadLocal.get();
    }

    public Cipher forEncryption(SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec) {
        return this.forMode(1, secretKey, algorithmParameterSpec);
    }

    public Cipher forDecryption(SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec) {
        return this.forMode(2, secretKey, algorithmParameterSpec);
    }

    public Cipher forWrapping(SecretKey secretKey) {
        return this.forMode(3, secretKey, null);
    }

    public Cipher forUnwrapping(SecretKey secretKey) {
        return this.forMode(4, secretKey, null);
    }

    Cipher forMode(int n, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec) {
        Cipher cipher = this.threadLocal.get();
        try {
            cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            return cipher;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key.", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("Algorithm parameter not appropriate for " + cipher.getAlgorithm() + ".", invalidAlgorithmParameterException);
        }
    }

    private class Provider
    extends ThreadLocal<Cipher> {
        private Provider() {
        }

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(CipherSupplier.this.cipherAlgorithm);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
                throw new IllegalArgumentException("Invalid cipher algorithm or padding.", generalSecurityException);
            }
        }
    }
}

