/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib;

import java.security.SecureRandom;
import org.cryptomator.cryptolib.DaggerCryptoLibComponent;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.common.SecureRandomModule;

public final class Cryptors {
    public static CryptorProvider version1(SecureRandom secureRandom) {
        return DaggerCryptoLibComponent.builder().secureRandomModule(new SecureRandomModule(secureRandom)).build().version1();
    }

    public static long cleartextSize(long l, Cryptor cryptor) {
        long l2;
        long l3 = cryptor.fileContentCryptor().cleartextChunkSize();
        long l4 = cryptor.fileContentCryptor().ciphertextChunkSize();
        long l5 = l4 - l3;
        long l6 = l / l4;
        long l7 = l % l4;
        if (l7 > 0L && l7 <= l5) {
            throw new IllegalArgumentException("Method not defined for input value " + l);
        }
        long l8 = l2 = l7 == 0L ? 0L : l7 - l5;
        assert (l2 >= 0L);
        return l3 * l6 + l2;
    }

    public static long ciphertextSize(long l, Cryptor cryptor) {
        long l2;
        long l3 = cryptor.fileContentCryptor().cleartextChunkSize();
        long l4 = cryptor.fileContentCryptor().ciphertextChunkSize();
        long l5 = l4 - l3;
        long l6 = l / l3;
        long l7 = l % l3;
        long l8 = l2 = l7 == 0L ? 0L : l7 + l5;
        assert (l2 >= 0L);
        return l4 * l6 + l2;
    }

    public static byte[] changePassphrase(CryptorProvider cryptorProvider, byte[] byArray, CharSequence charSequence, CharSequence charSequence2) throws InvalidPassphraseException {
        return Cryptors.changePassphrase(cryptorProvider, byArray, new byte[0], charSequence, charSequence2);
    }

    public static byte[] changePassphrase(CryptorProvider cryptorProvider, byte[] byArray, byte[] byArray2, CharSequence charSequence, CharSequence charSequence2) throws InvalidPassphraseException {
        KeyFile keyFile = KeyFile.parse(byArray);
        try (Cryptor cryptor = cryptorProvider.createFromKeyFile(keyFile, charSequence, byArray2, keyFile.getVersion());){
            byte[] byArray3 = cryptor.writeKeysToMasterkeyFile(charSequence2, byArray2, keyFile.getVersion()).serialize();
            return byArray3;
        }
    }
}

