/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemComponent;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.OpenCryptoFile;
import org.cryptomator.cryptofs.OpenCryptoFileModule;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.UncheckedThrows;

@PerFileSystem
class OpenCryptoFiles {
    private final CryptoFileSystemComponent component;
    private final FinallyUtil finallyUtil;
    private final ConcurrentMap<Path, OpenCryptoFile> openCryptoFiles = new ConcurrentHashMap<Path, OpenCryptoFile>();

    @Inject
    public OpenCryptoFiles(CryptoFileSystemComponent cryptoFileSystemComponent, FinallyUtil finallyUtil) {
        this.component = cryptoFileSystemComponent;
        this.finallyUtil = finallyUtil;
    }

    public OpenCryptoFile get(Path path, EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        Path path2 = path.toAbsolutePath().normalize();
        OpenCryptoFile openCryptoFile = UncheckedThrows.allowUncheckedThrowsOf(IOException.class).from(() -> this.openCryptoFiles.computeIfAbsent(path2, path2 -> this.create(path2, effectiveOpenOptions)));
        assert (openCryptoFile != null) : "computeIfAbsent will not return null";
        return openCryptoFile;
    }

    public void close() throws IOException {
        this.finallyUtil.guaranteeInvocationOf(this.openCryptoFiles.values().stream().map(openCryptoFile -> () -> openCryptoFile.close()).iterator());
    }

    private OpenCryptoFile create(Path path, EffectiveOpenOptions effectiveOpenOptions) {
        return this.component.newOpenCryptoFileComponent(OpenCryptoFileModule.openCryptoFileModule().withPath(path).withOptions(effectiveOpenOptions).onClose(() -> {
            OpenCryptoFile cfr_ignored_0 = (OpenCryptoFile)this.openCryptoFiles.remove(path);
        }).build()).openCryptoFile();
    }
}

