/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.PerProvider;

@PerProvider
class CryptoPathFactory {
    @Inject
    public CryptoPathFactory() {
    }

    public CryptoPath getPath(CryptoFileSystemImpl cryptoFileSystemImpl, String string, String ... stringArray) {
        boolean bl = string.startsWith("/");
        Stream<String> stream = Stream.concat(this.splitPath(string), Arrays.stream(stringArray).flatMap(this::splitPath));
        return new CryptoPath(cryptoFileSystemImpl, stream.collect(Collectors.toList()), bl);
    }

    public CryptoPath emptyFor(CryptoFileSystemImpl cryptoFileSystemImpl) {
        return new CryptoPath(cryptoFileSystemImpl, Collections.emptyList(), false);
    }

    public CryptoPath rootFor(CryptoFileSystemImpl cryptoFileSystemImpl) {
        return new CryptoPath(cryptoFileSystemImpl, Collections.emptyList(), true);
    }

    private Stream<String> splitPath(String string) {
        final StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return stringTokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return stringTokenizer.nextToken();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }
}

