/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.cryptomator.cryptofs.AsyncDelegatingFileChannel;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemProviderModule;
import org.cryptomator.cryptofs.CryptoFileSystemUri;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.DaggerCryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.FileSystemNeedsMigrationException;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.migration.Migrators;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;

public class CryptoFileSystemProvider
extends FileSystemProvider {
    private static final CryptorProvider CRYPTOR_PROVIDER = Cryptors.version1(CryptoFileSystemProvider.strongSecureRandom());
    private final CryptoFileSystems fileSystems;
    private final CopyOperation copyOperation;
    private final MoveOperation moveOperation;

    public CryptoFileSystemProvider() {
        CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent = DaggerCryptoFileSystemProviderComponent.builder().cryptoFileSystemProviderModule(new CryptoFileSystemProviderModule(this, CRYPTOR_PROVIDER)).build();
        this.fileSystems = cryptoFileSystemProviderComponent.fileSystems();
        this.copyOperation = cryptoFileSystemProviderComponent.copyOperation();
        this.moveOperation = cryptoFileSystemProviderComponent.moveOperation();
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", noSuchAlgorithmException);
        }
    }

    public static CryptoFileSystem newFileSystem(Path path, CryptoFileSystemProperties cryptoFileSystemProperties) throws FileSystemNeedsMigrationException, IOException {
        URI uRI = CryptoFileSystemUri.create(path.toAbsolutePath(), new String[0]);
        return (CryptoFileSystem)FileSystems.newFileSystem(uRI, cryptoFileSystemProperties);
    }

    public static void initialize(Path path, String string, CharSequence charSequence) throws NotDirectoryException, IOException {
        CryptoFileSystemProvider.initialize(path, string, new byte[0], charSequence);
    }

    public static void initialize(Path path, String string, byte[] byArray, CharSequence charSequence) throws NotDirectoryException, IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new NotDirectoryException(path.toString());
        }
        try (Cryptor cryptor = CRYPTOR_PROVIDER.createNew();){
            Path path2 = path.resolve(string);
            byte[] byArray2 = cryptor.writeKeysToMasterkeyFile(Normalizer.normalize(charSequence, Normalizer.Form.NFC), byArray, 6).serialize();
            Files.write(path2, byArray2, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            String string2 = cryptor.fileNameCryptor().hashDirectoryId("");
            Path path3 = path.resolve("d").resolve(string2.substring(0, 2)).resolve(string2.substring(2));
            Files.createDirectories(path3, new FileAttribute[0]);
        }
        assert (CryptoFileSystemProvider.containsVault(path, string));
    }

    public static boolean containsVault(Path path, String string) {
        Path path2 = path.resolve(string);
        Path path3 = path.resolve("d");
        return Files.isRegularFile(path2, new LinkOption[0]) && Files.isDirectory(path3, new LinkOption[0]);
    }

    public static void changePassphrase(Path path, String string, CharSequence charSequence, CharSequence charSequence2) throws InvalidPassphraseException, FileSystemNeedsMigrationException, IOException {
        CryptoFileSystemProvider.changePassphrase(path, string, new byte[0], charSequence, charSequence2);
    }

    public static void changePassphrase(Path path, String string, byte[] byArray, CharSequence charSequence, CharSequence charSequence2) throws InvalidPassphraseException, FileSystemNeedsMigrationException, IOException {
        if (Migrators.get().needsMigration(path, string)) {
            throw new FileSystemNeedsMigrationException(path);
        }
        String string2 = Normalizer.normalize(charSequence, Normalizer.Form.NFC);
        String string3 = Normalizer.normalize(charSequence2, Normalizer.Form.NFC);
        Path path2 = path.resolve(string);
        Path path3 = path.resolve(string + ".bkup");
        byte[] byArray2 = Files.readAllBytes(path2);
        byte[] byArray3 = Cryptors.changePassphrase(CRYPTOR_PROVIDER, byArray2, byArray, string2, string3);
        Files.move(path2, path3, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        Files.write(path2, byArray3, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    @Deprecated
    CryptoFileSystemProvider(CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent) {
        this.fileSystems = cryptoFileSystemProviderComponent.fileSystems();
        this.copyOperation = cryptoFileSystemProviderComponent.copyOperation();
        this.moveOperation = cryptoFileSystemProviderComponent.moveOperation();
    }

    @Deprecated
    CryptoFileSystems getCryptoFileSystems() {
        return this.fileSystems;
    }

    @Override
    public String getScheme() {
        return "cryptomator";
    }

    @Override
    public CryptoFileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        CryptoFileSystemUri cryptoFileSystemUri = CryptoFileSystemUri.parse(uRI);
        CryptoFileSystemProperties cryptoFileSystemProperties = CryptoFileSystemProperties.wrap(map);
        if (!CryptoFileSystemProvider.containsVault(cryptoFileSystemUri.pathToVault(), cryptoFileSystemProperties.masterkeyFilename())) {
            if (cryptoFileSystemProperties.initializeImplicitly()) {
                CryptoFileSystemProvider.initialize(cryptoFileSystemUri.pathToVault(), cryptoFileSystemProperties.masterkeyFilename(), cryptoFileSystemProperties.passphrase());
            } else {
                throw new NoSuchFileException(cryptoFileSystemUri.pathToVault().toString(), null, "Vault not initialized.");
            }
        }
        if (Migrators.get().needsMigration(cryptoFileSystemUri.pathToVault(), cryptoFileSystemProperties.masterkeyFilename())) {
            if (cryptoFileSystemProperties.migrateImplicitly()) {
                Migrators.get().migrate(cryptoFileSystemUri.pathToVault(), cryptoFileSystemProperties.masterkeyFilename(), cryptoFileSystemProperties.passphrase());
            } else {
                throw new FileSystemNeedsMigrationException(cryptoFileSystemUri.pathToVault());
            }
        }
        return this.fileSystems.create(cryptoFileSystemUri.pathToVault(), cryptoFileSystemProperties);
    }

    @Override
    public CryptoFileSystem getFileSystem(URI uRI) {
        CryptoFileSystemUri cryptoFileSystemUri = CryptoFileSystemUri.parse(uRI);
        return this.fileSystems.get(cryptoFileSystemUri.pathToVault());
    }

    @Override
    public Path getPath(URI uRI) {
        CryptoFileSystemUri cryptoFileSystemUri = CryptoFileSystemUri.parse(uRI);
        return this.fileSystems.get(cryptoFileSystemUri.pathToVault()).getPath(cryptoFileSystemUri.pathInsideVault(), new String[0]);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (set.contains(StandardOpenOption.APPEND)) {
            throw new IllegalArgumentException("AsynchronousFileChannel can not be opened in append mode");
        }
        return new AsyncDelegatingFileChannel(this.newFileChannel(path, set, fileAttributeArray), executorService);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return this.fileSystem(path).newFileChannel(CryptoPath.castAndAssertAbsolute(path), set, fileAttributeArray);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return this.newFileChannel(path, set, fileAttributeArray);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fileSystem(path).newDirectoryStream(CryptoPath.castAndAssertAbsolute(path), filter);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.fileSystem(path).createDirectory(CryptoPath.castAndAssertAbsolute(path), fileAttributeArray);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.fileSystem(path).delete(CryptoPath.castAndAssertAbsolute(path));
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        this.copyOperation.copy(CryptoPath.castAndAssertAbsolute(path), CryptoPath.castAndAssertAbsolute(path2), copyOptionArray);
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        this.moveOperation.move(CryptoPath.castAndAssertAbsolute(path), CryptoPath.castAndAssertAbsolute(path2), copyOptionArray);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.getFileSystem() == path2.getFileSystem() && path.toRealPath(new LinkOption[0]).equals(path2.toRealPath(new LinkOption[0]));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.fileSystem(path).isHidden(CryptoPath.castAndAssertAbsolute(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.fileSystem(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) throws IOException {
        this.fileSystem(path).checkAccess(CryptoPath.castAndAssertAbsolute(path), accessModeArray);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        return this.fileSystem(path).getFileAttributeView(CryptoPath.castAndAssertAbsolute(path), clazz, linkOptionArray);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        return this.fileSystem(path).readAttributes(CryptoPath.castAndAssertAbsolute(path), clazz, linkOptionArray);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        return this.fileSystem(path).readAttributes(CryptoPath.castAndAssertAbsolute(path), string, linkOptionArray);
    }

    @Override
    public void setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        this.fileSystem(path).setAttribute(CryptoPath.castAndAssertAbsolute(path), string, object, linkOptionArray);
    }

    private CryptoFileSystemImpl fileSystem(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem.provider() == this) {
            CryptoFileSystemImpl cryptoFileSystemImpl = (CryptoFileSystemImpl)fileSystem;
            cryptoFileSystemImpl.assertOpen();
            return cryptoFileSystemImpl;
        }
        throw new ProviderMismatchException("Used a path from provider " + fileSystem.provider() + " with provider " + this);
    }
}

