/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileAttributeViewProvider;
import org.cryptomator.cryptofs.DelegatingFileStore;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.UncheckedThrows;

@PerFileSystem
class CryptoFileStore
extends DelegatingFileStore {
    private static final String VIEW_NAME_BASIC = "basic";
    private static final String VIEW_NAME_OWNER = "owner";
    private static final String VIEW_NAME_POSIX = "posix";
    private static final String VIEW_NAME_DOS = "dos";
    private static final String[] VIEW_NAMES = new String[]{"basic", "owner", "posix", "dos"};
    private final Set<Class<? extends FileAttributeView>> supportedFileAttributeViewTypes;

    @Inject
    public CryptoFileStore(@PathToVault Path path, CryptoFileAttributeViewProvider cryptoFileAttributeViewProvider) {
        super(UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> Files.getFileStore(path)));
        this.supportedFileAttributeViewTypes = cryptoFileAttributeViewProvider.knownFileAttributeViewTypes().stream().filter(clazz -> super.supportsFileAttributeView((Class<? extends FileAttributeView>)clazz)).collect(Collectors.toSet());
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        return this.supportedFileAttributeViewTypes.stream().filter(clazz::isAssignableFrom).findAny().isPresent();
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        switch (string) {
            case "basic": {
                return this.supportsFileAttributeView(BasicFileAttributeView.class);
            }
            case "owner": {
                return this.supportsFileAttributeView(FileOwnerAttributeView.class);
            }
            case "posix": {
                return this.supportsFileAttributeView(PosixFileAttributeView.class);
            }
            case "dos": {
                return this.supportsFileAttributeView(DosFileAttributeView.class);
            }
        }
        return false;
    }

    Set<Class<? extends FileAttributeView>> supportedFileAttributeViewTypes() {
        return this.supportedFileAttributeViewTypes;
    }

    Set<String> supportedFileAttributeViewNames() {
        return Arrays.stream(VIEW_NAMES).filter(this::supportsFileAttributeView).collect(Collectors.toSet());
    }
}

