/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.BiConsumerThrowingException;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeViewProvider;
import org.cryptomator.cryptofs.PerFileSystem;

@PerFileSystem
class CryptoFileAttributeByNameProvider {
    private static final SortedMap<String, AttributeGetter<?>> GETTERS = new TreeMap();
    private static final SortedMap<String, AttributeSetter<?, ?>> SETTERS;
    private final CryptoFileAttributeProvider cryptoFileAttributeProvider;
    private final CryptoFileAttributeViewProvider cryptoFileAttributeViewProvider;

    private static <T extends BasicFileAttributes> void attribute(String string, Class<T> clazz, Function<T, ?> function) {
        String string2 = string.substring(string.indexOf(58) + 1);
        GETTERS.put(string, new AttributeGetter(string2, clazz, function));
    }

    private static <T extends BasicFileAttributeView, V> void attribute(String string, Class<T> clazz, Class<V> clazz2, BiConsumerThrowingException<T, V, IOException> biConsumerThrowingException) {
        SETTERS.put(string, new AttributeSetter(clazz, clazz2, biConsumerThrowingException));
    }

    @Inject
    public CryptoFileAttributeByNameProvider(CryptoFileAttributeProvider cryptoFileAttributeProvider, CryptoFileAttributeViewProvider cryptoFileAttributeViewProvider) {
        this.cryptoFileAttributeProvider = cryptoFileAttributeProvider;
        this.cryptoFileAttributeViewProvider = cryptoFileAttributeViewProvider;
    }

    public void setAttribute(Path path, String string, Object object) throws IOException {
        String string2 = this.normalizedAttributeName(string);
        AttributeSetter attributeSetter = (AttributeSetter)SETTERS.get(string2);
        if (attributeSetter == null) {
            throw new IllegalArgumentException("Unrecognized attribute name: " + string);
        }
        Object t = this.cryptoFileAttributeViewProvider.getAttributeView(path, attributeSetter.type());
        attributeSetter.set(t, object);
    }

    public Map<String, Object> readAttributes(Path path, String string) throws IOException {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("No attributes specified");
        }
        Predicate<String> predicate = this.getterNameFilter(string);
        Collection collection = GETTERS.entrySet().stream().filter(entry -> predicate.apply((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        return this.readAttributes(path, collection);
    }

    private Map<String, Object> readAttributes(Path path, Collection<AttributeGetter> collection) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object t = null;
        for (AttributeGetter attributeGetter : collection) {
            if (t == null) {
                t = this.cryptoFileAttributeProvider.readAttributes(path, attributeGetter.type());
            }
            String string = attributeGetter.name();
            hashMap.put(string, attributeGetter.read(t));
        }
        return hashMap;
    }

    private String normalizedAttributeName(String string) {
        if (string.indexOf(58) == -1) {
            return "basic:" + string;
        }
        return string;
    }

    private Predicate<String> getterNameFilter(String string) {
        String string3 = this.viewName(string);
        Set<String> set = this.attributeNames(string3, string);
        if (set.contains("*")) {
            String string4 = string3 + ":";
            return string2 -> string2.startsWith(string4);
        }
        return set::contains;
    }

    private String viewName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return "basic";
        }
        return string.substring(0, n);
    }

    private Set<String> attributeNames(String string, String string3) {
        int n = string3.indexOf(58);
        String string4 = n == -1 ? string3 : string3.substring(n + 1);
        return Arrays.stream(string4.split(",")).map(string2 -> {
            if ("*".equals(string2)) {
                return "*";
            }
            return string + ":" + string2;
        }).collect(Collectors.toSet());
    }

    static {
        CryptoFileAttributeByNameProvider.attribute("basic:lastModifiedTime", BasicFileAttributes.class, BasicFileAttributes::lastModifiedTime);
        CryptoFileAttributeByNameProvider.attribute("basic:lastAccessTime", BasicFileAttributes.class, BasicFileAttributes::lastAccessTime);
        CryptoFileAttributeByNameProvider.attribute("basic:creationTime", BasicFileAttributes.class, BasicFileAttributes::creationTime);
        CryptoFileAttributeByNameProvider.attribute("basic:isRegularFile", BasicFileAttributes.class, BasicFileAttributes::isRegularFile);
        CryptoFileAttributeByNameProvider.attribute("basic:isDirectory", BasicFileAttributes.class, BasicFileAttributes::isDirectory);
        CryptoFileAttributeByNameProvider.attribute("basic:isSymbolicLink", BasicFileAttributes.class, BasicFileAttributes::isSymbolicLink);
        CryptoFileAttributeByNameProvider.attribute("basic:isOther", BasicFileAttributes.class, BasicFileAttributes::isOther);
        CryptoFileAttributeByNameProvider.attribute("basic:size", BasicFileAttributes.class, BasicFileAttributes::size);
        CryptoFileAttributeByNameProvider.attribute("basic:fileKey", BasicFileAttributes.class, BasicFileAttributes::fileKey);
        CryptoFileAttributeByNameProvider.attribute("dos:readOnly", DosFileAttributes.class, DosFileAttributes::isReadOnly);
        CryptoFileAttributeByNameProvider.attribute("dos:hidden", DosFileAttributes.class, DosFileAttributes::isHidden);
        CryptoFileAttributeByNameProvider.attribute("dos:archive", DosFileAttributes.class, DosFileAttributes::isArchive);
        CryptoFileAttributeByNameProvider.attribute("dos:system", DosFileAttributes.class, DosFileAttributes::isSystem);
        CryptoFileAttributeByNameProvider.attribute("posix:owner", PosixFileAttributes.class, PosixFileAttributes::owner);
        CryptoFileAttributeByNameProvider.attribute("posix:group", PosixFileAttributes.class, PosixFileAttributes::group);
        CryptoFileAttributeByNameProvider.attribute("posix:permissions", PosixFileAttributes.class, PosixFileAttributes::permissions);
        SETTERS = new TreeMap();
        CryptoFileAttributeByNameProvider.attribute("basic:lastModifiedTime", BasicFileAttributeView.class, FileTime.class, (basicFileAttributeView, fileTime) -> basicFileAttributeView.setTimes((FileTime)fileTime, null, null));
        CryptoFileAttributeByNameProvider.attribute("basic:lastAccessTime", BasicFileAttributeView.class, FileTime.class, (basicFileAttributeView, fileTime) -> basicFileAttributeView.setTimes(null, (FileTime)fileTime, null));
        CryptoFileAttributeByNameProvider.attribute("basic:creationTime", BasicFileAttributeView.class, FileTime.class, (basicFileAttributeView, fileTime) -> basicFileAttributeView.setTimes(null, null, (FileTime)fileTime));
        CryptoFileAttributeByNameProvider.attribute("dos:readOnly", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setReadOnly);
        CryptoFileAttributeByNameProvider.attribute("dos:hidden", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setHidden);
        CryptoFileAttributeByNameProvider.attribute("dos:archive", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setArchive);
        CryptoFileAttributeByNameProvider.attribute("dos:system", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setSystem);
        CryptoFileAttributeByNameProvider.attribute("posix:owner", PosixFileAttributeView.class, UserPrincipal.class, FileOwnerAttributeView::setOwner);
        CryptoFileAttributeByNameProvider.attribute("posix:group", PosixFileAttributeView.class, GroupPrincipal.class, PosixFileAttributeView::setGroup);
        CryptoFileAttributeByNameProvider.attribute("posix:permissions", PosixFileAttributeView.class, Set.class, PosixFileAttributeView::setPermissions);
    }

    private static class AttributeGetter<T extends BasicFileAttributes> {
        private final String name;
        private final Class<T> type;
        private final Function<T, ?> getter;

        private AttributeGetter(String string, Class<T> clazz, Function<T, ?> function) {
            this.name = string;
            this.type = clazz;
            this.getter = function;
        }

        public String name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        public Object read(T t) {
            return this.getter.apply(t);
        }
    }

    private static class AttributeSetter<T extends FileAttributeView, V> {
        private final Class<T> type;
        private final Class<V> valueType;
        private final BiConsumerThrowingException<T, V, IOException> setter;

        private AttributeSetter(Class<T> clazz, Class<V> clazz2, BiConsumerThrowingException<T, V, IOException> biConsumerThrowingException) {
            this.type = clazz;
            this.valueType = clazz2;
            this.setter = biConsumerThrowingException;
        }

        public Class<T> type() {
            return this.type;
        }

        public void set(T t, Object object) throws IOException {
            this.setter.accept(t, this.valueType.cast(object));
        }
    }
}

