/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.EnumSet;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ArrayUtils;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.PerProvider;

@PerProvider
class CopyOperation {
    @Inject
    public CopyOperation() {
    }

    public void copy(CryptoPath cryptoPath, CryptoPath cryptoPath2, CopyOption ... copyOptionArray) throws IOException {
        if (cryptoPath.equals(cryptoPath2)) {
            return;
        }
        if (this.pathsBelongToSameFileSystem(cryptoPath, cryptoPath2)) {
            cryptoPath.getFileSystem().copy(cryptoPath, cryptoPath2, copyOptionArray);
        } else {
            BasicFileAttributeView basicFileAttributeView;
            Optional<BasicFileAttributes> optional = this.attributes(cryptoPath);
            Optional<BasicFileAttributes> optional2 = this.attributes(cryptoPath2);
            if (!optional.isPresent()) {
                throw new NoSuchFileException(cryptoPath.toUri().toString());
            }
            if (optional2.isPresent()) {
                if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.REPLACE_EXISTING)) {
                    this.provider(cryptoPath2).delete(cryptoPath2);
                } else {
                    throw new FileAlreadyExistsException(cryptoPath2.toUri().toString());
                }
            }
            if (optional.get().isDirectory()) {
                this.provider(cryptoPath2).createDirectory(cryptoPath2, new FileAttribute[0]);
            } else {
                this.transferFullFile(cryptoPath, cryptoPath2);
            }
            if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.COPY_ATTRIBUTES) && (basicFileAttributeView = this.provider(cryptoPath2).getFileAttributeView(cryptoPath2, BasicFileAttributeView.class, new LinkOption[0])) != null) {
                basicFileAttributeView.setTimes(optional.get().lastModifiedTime(), optional.get().lastAccessTime(), optional.get().creationTime());
            }
        }
    }

    private void transferFullFile(CryptoPath cryptoPath, CryptoPath cryptoPath2) throws IOException {
        try (FileChannel fileChannel = this.provider(cryptoPath).newFileChannel(cryptoPath, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);
             FileChannel fileChannel2 = this.provider(cryptoPath2).newFileChannel(cryptoPath2, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), new FileAttribute[0]);){
            long l = 0L;
            long l2 = fileChannel.size();
            while (l2 > 0L) {
                l += fileChannel.transferTo(l, l2, fileChannel2);
                l2 = fileChannel.size() - l;
            }
        }
    }

    private FileSystemProvider provider(CryptoPath cryptoPath) {
        return cryptoPath.getFileSystem().provider();
    }

    private boolean pathsBelongToSameFileSystem(CryptoPath cryptoPath, CryptoPath cryptoPath2) {
        return cryptoPath.getFileSystem() == cryptoPath2.getFileSystem();
    }

    private Optional<BasicFileAttributes> attributes(CryptoPath cryptoPath) {
        try {
            return Optional.of(this.provider(cryptoPath).readAttributes((Path)cryptoPath, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }
}

