/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ChunkData;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.PerOpenFile;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@PerOpenFile
class ChunkLoader {
    private final Cryptor cryptor;
    private final FileChannel channel;
    private final FileHeader header;
    private final CryptoFileSystemStats stats;

    @Inject
    public ChunkLoader(Cryptor cryptor, FileChannel fileChannel, FileHeader fileHeader, CryptoFileSystemStats cryptoFileSystemStats) {
        this.cryptor = cryptor;
        this.channel = fileChannel;
        this.header = fileHeader;
        this.stats = cryptoFileSystemStats;
    }

    public ChunkData load(Long l) throws IOException {
        ByteBuffer byteBuffer;
        this.stats.addChunkCacheMiss();
        int n = this.cryptor.fileContentCryptor().cleartextChunkSize();
        int n2 = this.cryptor.fileContentCryptor().ciphertextChunkSize();
        long l2 = l * (long)n2 + (long)this.cryptor.fileHeaderCryptor().headerSize();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        int n3 = this.channel.read(byteBuffer2, l2);
        if (n3 == -1) {
            return ChunkData.emptyWithSize(n);
        }
        byteBuffer2.flip();
        ByteBuffer byteBuffer3 = this.cryptor.fileContentCryptor().decryptChunk(byteBuffer2, l, this.header, true);
        this.stats.addBytesDecrypted(byteBuffer3.remaining());
        if (byteBuffer3.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
            byteBuffer.put(byteBuffer3);
            byteBuffer.flip();
        } else {
            byteBuffer = byteBuffer3;
        }
        return ChunkData.wrap(byteBuffer);
    }
}

