/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializationException;
import org.apache.http.client.cache.HttpCacheEntrySerializer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpCacheEntrySerializer
implements HttpCacheEntrySerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(HttpCacheEntry httpCacheEntry, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        try {
            objectOutputStream.writeObject(httpCacheEntry);
        }
        finally {
            objectOutputStream.close();
        }
    }

    @Override
    public HttpCacheEntry readFrom(InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            HttpCacheEntry httpCacheEntry = (HttpCacheEntry)objectInputStream.readObject();
            return httpCacheEntry;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HttpCacheEntrySerializationException("Class not found: " + classNotFoundException.getMessage(), classNotFoundException);
        }
        finally {
            objectInputStream.close();
        }
    }
}

