/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.utils.DateUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheValidityPolicy {
    public static final long MAX_AGE = 0x80000000L;

    CacheValidityPolicy() {
    }

    public long getCurrentAgeSecs(HttpCacheEntry httpCacheEntry, Date date) {
        return this.getCorrectedInitialAgeSecs(httpCacheEntry) + this.getResidentTimeSecs(httpCacheEntry, date);
    }

    public long getFreshnessLifetimeSecs(HttpCacheEntry httpCacheEntry) {
        long l = this.getMaxAge(httpCacheEntry);
        if (l > -1L) {
            return l;
        }
        Date date = httpCacheEntry.getDate();
        if (date == null) {
            return 0L;
        }
        Date date2 = this.getExpirationDate(httpCacheEntry);
        if (date2 == null) {
            return 0L;
        }
        long l2 = date2.getTime() - date.getTime();
        return l2 / 1000L;
    }

    public boolean isResponseFresh(HttpCacheEntry httpCacheEntry, Date date) {
        return this.getCurrentAgeSecs(httpCacheEntry, date) < this.getFreshnessLifetimeSecs(httpCacheEntry);
    }

    public boolean isResponseHeuristicallyFresh(HttpCacheEntry httpCacheEntry, Date date, float f, long l) {
        return this.getCurrentAgeSecs(httpCacheEntry, date) < this.getHeuristicFreshnessLifetimeSecs(httpCacheEntry, f, l);
    }

    public long getHeuristicFreshnessLifetimeSecs(HttpCacheEntry httpCacheEntry, float f, long l) {
        Date date = httpCacheEntry.getDate();
        Date date2 = this.getLastModifiedValue(httpCacheEntry);
        if (date != null && date2 != null) {
            long l2 = date.getTime() - date2.getTime();
            if (l2 < 0L) {
                return 0L;
            }
            return (long)(f * (float)(l2 / 1000L));
        }
        return l;
    }

    public boolean isRevalidatable(HttpCacheEntry httpCacheEntry) {
        return httpCacheEntry.getFirstHeader("ETag") != null || httpCacheEntry.getFirstHeader("Last-Modified") != null;
    }

    public boolean mustRevalidate(HttpCacheEntry httpCacheEntry) {
        return this.hasCacheControlDirective(httpCacheEntry, "must-revalidate");
    }

    public boolean proxyRevalidate(HttpCacheEntry httpCacheEntry) {
        return this.hasCacheControlDirective(httpCacheEntry, "proxy-revalidate");
    }

    public boolean mayReturnStaleWhileRevalidating(HttpCacheEntry httpCacheEntry, Date date) {
        for (Header header : httpCacheEntry.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"stale-while-revalidate".equalsIgnoreCase(headerElement.getName())) continue;
                try {
                    int n = Integer.parseInt(headerElement.getValue());
                    if (this.getStalenessSecs(httpCacheEntry, date) > (long)n) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean mayReturnStaleIfError(HttpRequest httpRequest, HttpCacheEntry httpCacheEntry, Date date) {
        long l = this.getStalenessSecs(httpCacheEntry, date);
        return this.mayReturnStaleIfError(httpRequest.getHeaders("Cache-Control"), l) || this.mayReturnStaleIfError(httpCacheEntry.getHeaders("Cache-Control"), l);
    }

    private boolean mayReturnStaleIfError(Header[] headerArray, long l) {
        boolean bl = false;
        block2: for (Header header : headerArray) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"stale-if-error".equals(headerElement.getName())) continue;
                try {
                    int n = Integer.parseInt(headerElement.getValue());
                    if (l > (long)n) continue;
                    bl = true;
                    continue block2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    @Deprecated
    protected Date getDateValue(HttpCacheEntry httpCacheEntry) {
        return httpCacheEntry.getDate();
    }

    protected Date getLastModifiedValue(HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Last-Modified");
        if (header == null) {
            return null;
        }
        return DateUtils.parseDate(header.getValue());
    }

    protected long getContentLengthValue(HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Content-Length");
        if (header == null) {
            return -1L;
        }
        try {
            return Long.parseLong(header.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    protected boolean hasContentLengthHeader(HttpCacheEntry httpCacheEntry) {
        return null != httpCacheEntry.getFirstHeader("Content-Length");
    }

    protected boolean contentLengthHeaderMatchesActualLength(HttpCacheEntry httpCacheEntry) {
        return !this.hasContentLengthHeader(httpCacheEntry) || httpCacheEntry.getResource() != null && this.getContentLengthValue(httpCacheEntry) == httpCacheEntry.getResource().length();
    }

    protected long getApparentAgeSecs(HttpCacheEntry httpCacheEntry) {
        Date date = httpCacheEntry.getDate();
        if (date == null) {
            return 0x80000000L;
        }
        long l = httpCacheEntry.getResponseDate().getTime() - date.getTime();
        if (l < 0L) {
            return 0L;
        }
        return l / 1000L;
    }

    protected long getAgeValue(HttpCacheEntry httpCacheEntry) {
        long l = 0L;
        for (Header header : httpCacheEntry.getHeaders("Age")) {
            long l2;
            try {
                l2 = Long.parseLong(header.getValue());
                if (l2 < 0L) {
                    l2 = 0x80000000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l2 = 0x80000000L;
            }
            l = l2 > l ? l2 : l;
        }
        return l;
    }

    protected long getCorrectedReceivedAgeSecs(HttpCacheEntry httpCacheEntry) {
        long l;
        long l2 = this.getApparentAgeSecs(httpCacheEntry);
        return l2 > (l = this.getAgeValue(httpCacheEntry)) ? l2 : l;
    }

    protected long getResponseDelaySecs(HttpCacheEntry httpCacheEntry) {
        long l = httpCacheEntry.getResponseDate().getTime() - httpCacheEntry.getRequestDate().getTime();
        return l / 1000L;
    }

    protected long getCorrectedInitialAgeSecs(HttpCacheEntry httpCacheEntry) {
        return this.getCorrectedReceivedAgeSecs(httpCacheEntry) + this.getResponseDelaySecs(httpCacheEntry);
    }

    protected long getResidentTimeSecs(HttpCacheEntry httpCacheEntry, Date date) {
        long l = date.getTime() - httpCacheEntry.getResponseDate().getTime();
        return l / 1000L;
    }

    protected long getMaxAge(HttpCacheEntry httpCacheEntry) {
        long l = -1L;
        for (Header header : httpCacheEntry.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"max-age".equals(headerElement.getName()) && !"s-maxage".equals(headerElement.getName())) continue;
                try {
                    long l2 = Long.parseLong(headerElement.getValue());
                    if (l != -1L && l2 >= l) continue;
                    l = l2;
                }
                catch (NumberFormatException numberFormatException) {
                    l = 0L;
                }
            }
        }
        return l;
    }

    protected Date getExpirationDate(HttpCacheEntry httpCacheEntry) {
        Header header = httpCacheEntry.getFirstHeader("Expires");
        if (header == null) {
            return null;
        }
        return DateUtils.parseDate(header.getValue());
    }

    public boolean hasCacheControlDirective(HttpCacheEntry httpCacheEntry, String string) {
        for (Header header : httpCacheEntry.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!string.equalsIgnoreCase(headerElement.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public long getStalenessSecs(HttpCacheEntry httpCacheEntry, Date date) {
        long l;
        long l2 = this.getCurrentAgeSecs(httpCacheEntry, date);
        if (l2 <= (l = this.getFreshnessLifetimeSecs(httpCacheEntry))) {
            return 0L;
        }
        return l2 - l;
    }
}

