/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicHttpCacheStorage
implements HttpCacheStorage {
    private final CacheMap entries;

    public BasicHttpCacheStorage(CacheConfig cacheConfig) {
        this.entries = new CacheMap(cacheConfig.getMaxCacheEntries());
    }

    @Override
    public synchronized void putEntry(String string, HttpCacheEntry httpCacheEntry) throws IOException {
        this.entries.put(string, httpCacheEntry);
    }

    @Override
    public synchronized HttpCacheEntry getEntry(String string) throws IOException {
        return (HttpCacheEntry)this.entries.get(string);
    }

    @Override
    public synchronized void removeEntry(String string) throws IOException {
        this.entries.remove(string);
    }

    @Override
    public synchronized void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) throws IOException {
        HttpCacheEntry httpCacheEntry = (HttpCacheEntry)this.entries.get(string);
        this.entries.put(string, httpCacheUpdateCallback.update(httpCacheEntry));
    }
}

