/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.entity.mime.AbstractMultipartForm;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.Header;
import org.apache.http.entity.mime.MinimalField;

class HttpBrowserCompatibleMultipart
extends AbstractMultipartForm {
    private final List<FormBodyPart> parts;

    public HttpBrowserCompatibleMultipart(Charset charset, String string, List<FormBodyPart> list) {
        super(charset, string);
        this.parts = list;
    }

    @Override
    public List<FormBodyPart> getBodyParts() {
        return this.parts;
    }

    @Override
    protected void formatMultipartHeader(FormBodyPart formBodyPart, OutputStream outputStream) throws IOException {
        Header header = formBodyPart.getHeader();
        MinimalField minimalField = header.getField("Content-Disposition");
        HttpBrowserCompatibleMultipart.writeField(minimalField, this.charset, outputStream);
        String string = formBodyPart.getBody().getFilename();
        if (string != null) {
            MinimalField minimalField2 = header.getField("Content-Type");
            HttpBrowserCompatibleMultipart.writeField(minimalField2, this.charset, outputStream);
        }
    }
}

