/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFileFilter
extends AbstractFileFilter {
    private String[] wildcards;
    private IOCase caseSensitivity;

    public WildcardFileFilter(String string) {
        this(string, null);
    }

    public WildcardFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = stringArray;
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(List list) {
        this(list, null);
    }

    public WildcardFileFilter(List list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public boolean accept(File file, String string) {
        int n = 0;
        while (n < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(string, this.wildcards[n], this.caseSensitivity)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean accept(File file) {
        String string = file.getName();
        int n = 0;
        while (n < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(string, this.wildcards[n], this.caseSensitivity)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

