/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.List;

public class Option
implements Cloneable {
    public static final int UNINITIALIZED = -1;
    public static final int UNLIMITED_VALUES = -2;
    private String opt;
    private String longOpt;
    private boolean hasArg;
    private String argName;
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int numberOfArgs = -1;
    private Object type;
    private ArrayList values = new ArrayList();
    private char id;
    private char valuesep;

    private void validateOption(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("opt is null");
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!this.isValidOpt(c)) {
                throw new IllegalArgumentException("illegal option value '" + c + "'");
            }
            this.id = c;
        } else {
            char[] cArray = string.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (!this.isValidChar(cArray[n])) {
                    throw new IllegalArgumentException("opt contains illegal character value '" + cArray[n] + "'");
                }
                ++n;
            }
        }
    }

    private boolean isValidOpt(char c) {
        return this.isValidChar(c) || c == ' ' || c == '?' || c == '@';
    }

    private boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public int getId() {
        return this.id;
    }

    public Option(String string, String string2) throws IllegalArgumentException {
        this(string, null, false, string2);
    }

    public Option(String string, boolean bl, String string2) throws IllegalArgumentException {
        this(string, null, bl, string2);
    }

    public Option(String string, String string2, boolean bl, String string3) throws IllegalArgumentException {
        this.validateOption(string);
        this.opt = string;
        this.longOpt = string2;
        if (bl) {
            this.numberOfArgs = 1;
        }
        this.hasArg = bl;
        this.description = string3;
    }

    public String getOpt() {
        return this.opt;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object object) {
        this.type = object;
    }

    public String getLongOpt() {
        return this.longOpt;
    }

    public void setLongOpt(String string) {
        this.longOpt = string;
    }

    public void setOptionalArg(boolean bl) {
        this.optionalArg = bl;
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasLongOpt() {
        return this.longOpt != null;
    }

    public boolean hasArg() {
        return this.numberOfArgs > 0 || this.numberOfArgs == -2;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setArgName(String string) {
        this.argName = string;
    }

    public String getArgName() {
        return this.argName;
    }

    public boolean hasArgName() {
        return this.argName != null && this.argName.length() > 0;
    }

    public boolean hasArgs() {
        return this.numberOfArgs > 1 || this.numberOfArgs == -2;
    }

    public void setArgs(int n) {
        this.numberOfArgs = n;
    }

    public void setValueSeparator(char c) {
        this.valuesep = c;
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public int getArgs() {
        return this.numberOfArgs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[ option: ");
        stringBuffer.append(this.opt);
        if (this.longOpt != null) {
            stringBuffer.append(" ").append(this.longOpt);
        }
        stringBuffer.append(" ");
        if (this.hasArg) {
            stringBuffer.append("+ARG");
        }
        stringBuffer.append(" :: ").append(this.description);
        if (this.type != null) {
            stringBuffer.append(" :: ").append(this.type);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public boolean addValue(String string) {
        switch (this.numberOfArgs) {
            case -1: {
                return false;
            }
            case -2: {
                if (this.getValueSeparator() > '\u0000') {
                    int n = 0;
                    while ((n = string.indexOf(this.getValueSeparator())) != -1) {
                        this.values.add(string.substring(0, n));
                        string = string.substring(n + 1);
                    }
                }
                this.values.add(string);
                return true;
            }
        }
        if (this.getValueSeparator() > '\u0000') {
            int n = 0;
            while ((n = string.indexOf(this.getValueSeparator())) != -1) {
                if (this.values.size() > this.numberOfArgs - 1) {
                    return false;
                }
                this.values.add(string.substring(0, n));
                string = string.substring(n + 1);
            }
        }
        if (this.values.size() > this.numberOfArgs - 1) {
            return false;
        }
        this.values.add(string);
        return true;
    }

    public String getValue() {
        return this.values.size() == 0 ? null : (String)this.values.get(0);
    }

    public String getValue(int n) throws IndexOutOfBoundsException {
        return this.values.size() == 0 ? null : (String)this.values.get(n);
    }

    public String getValue(String string) {
        String string2 = this.getValue();
        return string2 != null ? string2 : string;
    }

    public String[] getValues() {
        return this.values.size() == 0 ? null : this.values.toArray(new String[0]);
    }

    public List getValuesList() {
        return this.values;
    }

    public Object clone() {
        Option option = new Option(this.getOpt(), this.getDescription());
        option.setArgs(this.getArgs());
        option.setOptionalArg(this.hasOptionalArg());
        option.setRequired(this.isRequired());
        option.setLongOpt(this.getLongOpt());
        option.setType(this.getType());
        option.setValueSeparator(this.getValueSeparator());
        return option;
    }
}

