/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify;

import java.io.File;
import java.io.IOException;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;

public class JNotify {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_RENAMED = 8;
    public static final int FILE_ANY = 15;
    private static IJNotify _instance;

    public static int addWatch(String string, int n, boolean bl, JNotifyListener jNotifyListener) throws JNotifyException {
        return _instance.addWatch(string, n, bl, jNotifyListener);
    }

    public static boolean removeWatch(int n) throws JNotifyException {
        return _instance.removeWatch(n);
    }

    public static void main(String[] stringArray) throws InterruptedException, IOException {
        String string = new File(stringArray.length == 0 ? "." : stringArray[0]).getCanonicalFile().getAbsolutePath();
        JNotify.addWatch(string, 15, true, new JNotifyListener(){

            @Override
            public void fileRenamed(int n, String string, String string2, String string3) {
                System.out.println("renamed " + string + " : " + string2 + " -> " + string3);
            }

            @Override
            public void fileModified(int n, String string, String string2) {
                System.out.println("modified " + string + " : " + string2);
            }

            @Override
            public void fileDeleted(int n, String string, String string2) {
                System.out.println("deleted " + string + " : " + string2);
            }

            @Override
            public void fileCreated(int n, String string, String string2) {
                System.out.println("created " + string + " : " + string2);
            }
        });
        System.out.println("Monitoring " + string + ", ctrl+c to stop");
        while (true) {
            Thread.sleep(10000L);
        }
    }

    static {
        String string = System.getProperty("jnotify.impl.override");
        if (string != null) {
            try {
                _instance = (IJNotify)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            String string2 = System.getProperty("os.name").toLowerCase();
            if (string2.equals("linux")) {
                try {
                    _instance = (IJNotify)Class.forName("net.contentobjects.jnotify.linux.JNotifyAdapterLinux").newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            } else if (string2.startsWith("windows")) {
                try {
                    _instance = (IJNotify)Class.forName("net.contentobjects.jnotify.win32.JNotifyAdapterWin32").newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            } else if (string2.startsWith("mac os x")) {
                try {
                    _instance = (IJNotify)Class.forName("net.contentobjects.jnotify.macosx.JNotifyAdapterMacOSX").newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            } else {
                throw new RuntimeException("Unsupported OS : " + string2);
            }
        }
    }
}

