/*
 * Decompiled with CFR 0.152.
 */
package jwf;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jwf.NullWizardPanel;
import jwf.WizardContext;
import jwf.WizardListener;
import jwf.WizardPanel;

public class Wizard
extends JPanel
implements ActionListener {
    public static final Dimension WIZARD_WINDOW_SIZE = new Dimension(500, 375);
    public static final Dimension WIZARD_MAC_WINDOW_SIZE = new Dimension(600, 450);
    public static final String BACK_I18N = "BACK_I18N";
    public static final String NEXT_I18N = "NEXT_I18N";
    public static final String FINISH_I18N = "FINISH_I18N";
    public static final String CANCEL_I18N = "CANCEL_I18N";
    public static final String HELP_I18N = "HELP_I18N";
    public static final String BACK_I18N_DESCRIPTION = "BACK_I18N_DESCRIPTION";
    public static final String NEXT_I18N_DESCRIPTION = "NEXT_I18N_DESCRIPTION";
    public static final String FINISH_I18N_DESCRIPTION = "FINISH_I18N_DESCRIPTION";
    public static final String CANCEL_I18N_DESCRIPTION = "CANCEL_I18N_DESCRIPTION";
    public static final String HELP_I18N_DESCRIPTION = "HELP_I18N_DESCRIPTION";
    private final JButton backButton = new JButton("< Back");
    private final JButton nextButton = new JButton("Next >");
    private final JButton finishButton = new JButton("Finish");
    private final JButton cancelButton = new JButton("Cancel");
    private final JButton helpButton = new JButton("Help");
    private final JLabel poweredByLabel;
    private final Set<WizardListener> listeners = new HashSet<WizardListener>();
    private Stack<WizardPanel> previous;
    private WizardPanel current;
    private WizardContext ctx;

    public Wizard() {
        Icon icon = Icons.getIconById("poweredby.icon");
        if (icon != null) {
            this.poweredByLabel = new JLabel(icon);
            this.poweredByLabel.setCursor(new Cursor(12));
            this.poweredByLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        BrowserLauncher.openURL("https://www.powerfolder.com");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.poweredByLabel.setVisible(false);
        } else {
            this.poweredByLabel = null;
        }
        this.init();
    }

    private void init() {
        this.ctx = new WizardContext();
        this.nextButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        buttonBarBuilder.addGridded(this.backButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(this.nextButton);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded(this.cancelButton);
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setOpaque(false);
        JPanel jPanel2 = ButtonBarFactory.buildCenteredBar(this.helpButton);
        jPanel2.setOpaque(false);
        jPanel.setBorder(Borders.DLU2_BORDER);
        jPanel2.setBorder(Borders.DLU2_BORDER);
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "West");
        if (this.poweredByLabel != null) {
            jPanel3.add((Component)this.poweredByLabel, "West");
            int n = Math.max(jPanel3.getPreferredSize().height, this.poweredByLabel.getPreferredSize().height);
            jPanel3.setPreferredSize(new Dimension(jPanel3.getPreferredSize().width, n));
        }
        jPanel3.add((Component)jPanel, "East");
        this.add((Component)jPanel3, "South");
        if (OSUtil.isMacOS()) {
            this.setMinimumSize(WIZARD_MAC_WINDOW_SIZE);
            this.setPreferredSize(WIZARD_MAC_WINDOW_SIZE);
        } else {
            this.setMinimumSize(WIZARD_WINDOW_SIZE);
            this.setPreferredSize(WIZARD_WINDOW_SIZE);
        }
    }

    public void setI18NMap(Map<String, String> map) {
        if (!map.isEmpty()) {
            this.nextButton.setText(map.get(NEXT_I18N));
            this.nextButton.setToolTipText(map.get(NEXT_I18N_DESCRIPTION));
            this.nextButton.setIcon(Icons.getIconById("arrow_right.icon"));
            this.nextButton.setHorizontalTextPosition(2);
            this.nextButton.setActionCommand("Next >");
            this.backButton.setText(map.get(BACK_I18N));
            this.backButton.setToolTipText(map.get(BACK_I18N_DESCRIPTION));
            this.backButton.setIcon(Icons.getIconById("arrow_left.icon"));
            this.backButton.setActionCommand("< Back");
            this.finishButton.setText(map.get(FINISH_I18N));
            this.finishButton.setToolTipText(map.get(FINISH_I18N_DESCRIPTION));
            this.finishButton.setMinimumSize(this.nextButton.getMinimumSize());
            this.finishButton.setMaximumSize(this.nextButton.getMaximumSize());
            this.finishButton.setPreferredSize(this.nextButton.getPreferredSize());
            this.finishButton.setActionCommand("Finish");
            this.cancelButton.setText(map.get(CANCEL_I18N));
            this.cancelButton.setToolTipText(map.get(CANCEL_I18N_DESCRIPTION));
            this.cancelButton.setActionCommand("Cancel");
            this.cancelButton.setMinimumSize(this.nextButton.getMinimumSize());
            this.cancelButton.setMaximumSize(this.nextButton.getMaximumSize());
            this.cancelButton.setPreferredSize(this.nextButton.getPreferredSize());
            this.helpButton.setText(map.get(HELP_I18N));
            this.helpButton.setToolTipText(map.get(HELP_I18N_DESCRIPTION));
            this.helpButton.setActionCommand("Help");
        }
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.listeners.add(wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.listeners.remove(wizardListener);
    }

    public void start(WizardPanel wizardPanel, boolean bl) {
        this.previous = new Stack();
        if (bl) {
            this.ctx = new WizardContext();
        }
        this.ctx.setAttribute("wizard", this);
        wizardPanel.setWizardContext(this.ctx);
        this.setPanel(wizardPanel);
        this.updateButtons();
        this.setupMenu();
    }

    private void setupMenu() {
        MyJMenuBar myJMenuBar = new MyJMenuBar();
        this.add((Component)myJMenuBar, "North");
        MyHelpAction myHelpAction = new MyHelpAction();
        myJMenuBar.add(new JMenuItem(myHelpAction));
    }

    public WizardContext getContext() {
        return this.ctx;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("< Back".equals(string)) {
            this.back();
        } else if ("Next >".equals(string)) {
            this.next();
        } else if ("Finish".equals(string)) {
            this.finish();
        } else if ("Cancel".equals(string)) {
            this.cancel();
        } else if ("Help".equals(string)) {
            this.help();
        }
    }

    private void setPanel(WizardPanel wizardPanel) {
        if (null != this.current) {
            this.remove(this.current);
        }
        this.current = wizardPanel;
        if (null == this.current) {
            this.current = new NullWizardPanel();
        }
        this.add((Component)this.current, "Center");
        for (WizardListener wizardListener : this.listeners) {
            wizardListener.wizardPanelChanged(this);
        }
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.current.display();
    }

    void updateButtons() {
        Wizard.enableButton(this.cancelButton, this.current.canCancel());
        Wizard.enableButton(this.helpButton, this.current.hasHelp());
        boolean bl = !this.previous.isEmpty() && this.previous.peek().canGoBackTo();
        Wizard.enableButton(this.backButton, bl);
        Wizard.enableButton(this.finishButton, this.current.canFinish());
        if (this.poweredByLabel != null) {
            this.poweredByLabel.setVisible(!bl && !this.current.hasHelp() && !this.current.hasNext());
        }
        if (this.nextButton.hasFocus() && !this.current.hasNext()) {
            this.helpButton.requestFocus();
        } else if (this.finishButton.hasFocus() && !this.current.canFinish()) {
            this.finishButton.requestFocus();
        }
        Wizard.enableButton(this.nextButton, this.current.hasNext());
    }

    private static void enableButton(JButton jButton, boolean bl) {
        jButton.setEnabled(bl);
        jButton.setVisible(bl);
    }

    public void back() {
        WizardPanel wizardPanel = this.previous.pop();
        this.setPanel(wizardPanel);
        this.updateButtons();
    }

    public void next() {
        Cursor cursor = CursorUtils.setWaitCursor(this);
        try {
            if (this.current.validateNext()) {
                this.previous.push(this.current);
                WizardPanel wizardPanel = this.current.next();
                if (null != wizardPanel) {
                    wizardPanel.setWizardContext(this.ctx);
                }
                this.setPanel(wizardPanel);
                this.updateButtons();
            }
        }
        finally {
            CursorUtils.returnToOriginal(this, cursor);
        }
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public WizardPanel getCurrentPanel() {
        return this.current;
    }

    private void finish() {
        if (this.current.validateFinish()) {
            this.current.finish();
            for (WizardListener wizardListener : this.listeners) {
                wizardListener.wizardFinished(this);
            }
        }
    }

    private void cancel() {
        for (WizardListener wizardListener : this.listeners) {
            wizardListener.wizardCancelled(this);
        }
    }

    private void help() {
        this.current.help();
    }

    private static class MyJMenuBar
    extends JMenuBar {
        private MyJMenuBar() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)super.getPreferredSize().getWidth(), 0);
        }
    }

    private class MyHelpAction
    extends AbstractAction {
        private MyHelpAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(56, 8));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.help();
        }
    }
}

