/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistence {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

    public static EntityManagerFactory createEntityManagerFactory(String string) {
        return Persistence.createEntityManagerFactory(string, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String string, Map map) {
        PersistenceProvider persistenceProvider;
        EntityManagerFactory entityManagerFactory = null;
        if (providers.size() == 0) {
            Persistence.findAllProviders();
        }
        Iterator<PersistenceProvider> iterator = providers.iterator();
        while (iterator.hasNext() && (entityManagerFactory = (persistenceProvider = iterator.next()).createEntityManagerFactory(string, map)) == null) {
        }
        if (entityManagerFactory == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + string);
        }
        return entityManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllProviders() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/services/" + PersistenceProvider.class.getName());
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream object = uRL.openStream();
                try {
                    hashSet.addAll(Persistence.providerNamesFromReader(new BufferedReader(new InputStreamReader(object))));
                }
                finally {
                    object.close();
                }
            }
            for (String string : hashSet) {
                Class<?> clazz = classLoader.loadClass(string);
                providers.add((PersistenceProvider)clazz.newInstance());
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException(iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException(classNotFoundException);
        }
    }

    private static Set<String> providerNamesFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = nonCommentPattern.matcher(string = string.trim());
            if (!matcher.find()) continue;
            hashSet.add(matcher.group().trim());
        }
        return hashSet;
    }
}

