/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.Cleaner0;
import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.UnsafeAtomicIntegerFieldUpdater;
import io.netty.util.internal.UnsafeAtomicLongFieldUpdater;
import io.netty.util.internal.UnsafeAtomicReferenceFieldUpdater;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    static final int HASH_CODE_C1 = 461845907;
    static final int HASH_CODE_C2 = 461845907;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n), n);
    }

    static ByteBuffer allocateDirectNoCleaner(int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(n), n);
    }

    private static ByteBuffer newDirectBuffer(long l, int n) {
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l, n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
    }

    static void freeDirectBuffer(ByteBuffer byteBuffer) {
        Cleaner0.freeDirectBuffer(byteBuffer);
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l) {
        return UNSAFE.getObject(object, l);
    }

    static Object getObjectVolatile(Object object, long l) {
        return UNSAFE.getObjectVolatile(object, l);
    }

    static int getInt(Object object, long l) {
        return UNSAFE.getInt(object, l);
    }

    private static long getLong(Object object, long l) {
        return UNSAFE.getLong(object, l);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l) {
        return UNSAFE.getByte(l);
    }

    static short getShort(long l) {
        return UNSAFE.getShort(l);
    }

    static int getInt(long l) {
        return UNSAFE.getInt(l);
    }

    static long getLong(long l) {
        return UNSAFE.getLong(l);
    }

    static byte getByte(byte[] byArray, int n) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static short getShort(byte[] byArray, int n) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static int getInt(byte[] byArray, int n) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static long getLong(byte[] byArray, int n) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static void putOrderedObject(Object object, long l, Object object2) {
        UNSAFE.putOrderedObject(object, l, object2);
    }

    static void putByte(long l, byte by) {
        UNSAFE.putByte(l, by);
    }

    static void putShort(long l, short s) {
        UNSAFE.putShort(l, s);
    }

    static void putInt(long l, int n) {
        UNSAFE.putInt(l, n);
    }

    static void putLong(long l, long l2) {
        UNSAFE.putLong(l, l2);
    }

    static void putByte(byte[] byArray, int n, byte by) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, by);
    }

    static void putShort(byte[] byArray, int n, short s) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, s);
    }

    static void putInt(byte[] byArray, int n, int n2) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, n2);
    }

    static void putLong(byte[] byArray, int n, long l) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l);
    }

    static void copyMemory(long l, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(l, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void copyMemory(Object object, long l, Object object2, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(object, l, object2, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void setMemory(long l, long l2, byte by) {
        UNSAFE.setMemory(l, l2, by);
    }

    static void setMemory(Object object, long l, long l2, byte by) {
        UNSAFE.setMemory(object, l, l2, by);
    }

    static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        int n4 = n3 & 7;
        long l3 = l + (long)n4;
        long l4 = l - 8L + (long)n3;
        long l5 = l2 - 8L + (long)n3;
        while (l4 >= l3) {
            if (UNSAFE.getLong(byArray, l4) != UNSAFE.getLong(byArray2, l5)) {
                return false;
            }
            l4 -= 8L;
            l5 -= 8L;
        }
        switch (n4) {
            case 7: {
                return UNSAFE.getInt(byArray, l + 3L) == UNSAFE.getInt(byArray2, l2 + 3L) && UNSAFE.getChar(byArray, l + 1L) == UNSAFE.getChar(byArray2, l2 + 1L) && UNSAFE.getByte(byArray, l) == UNSAFE.getByte(byArray2, l2);
            }
            case 6: {
                return UNSAFE.getInt(byArray, l + 2L) == UNSAFE.getInt(byArray2, l2 + 2L) && UNSAFE.getChar(byArray, l) == UNSAFE.getChar(byArray2, l2);
            }
            case 5: {
                return UNSAFE.getInt(byArray, l + 1L) == UNSAFE.getInt(byArray2, l2 + 1L) && UNSAFE.getByte(byArray, l) == UNSAFE.getByte(byArray2, l2);
            }
            case 4: {
                return UNSAFE.getInt(byArray, l) == UNSAFE.getInt(byArray2, l2);
            }
            case 3: {
                return UNSAFE.getChar(byArray, l + 1L) == UNSAFE.getChar(byArray2, l2 + 1L) && UNSAFE.getByte(byArray, l) == UNSAFE.getByte(byArray2, l2);
            }
            case 2: {
                return UNSAFE.getChar(byArray, l) == UNSAFE.getChar(byArray2, l2);
            }
            case 1: {
                return UNSAFE.getByte(byArray, l) == UNSAFE.getByte(byArray2, l2);
            }
        }
        return true;
    }

    static int equalsConstantTime(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l = 0L;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l3 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        int n4 = n3 & 7;
        long l4 = l2 + (long)n4;
        long l5 = l2 - 8L + (long)n3;
        long l6 = l3 - 8L + (long)n3;
        while (l5 >= l4) {
            l |= UNSAFE.getLong(byArray, l5) ^ UNSAFE.getLong(byArray2, l6);
            l5 -= 8L;
            l6 -= 8L;
        }
        switch (n4) {
            case 7: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getInt(byArray, l2 + 3L) ^ UNSAFE.getInt(byArray2, l3 + 3L)) | (long)(UNSAFE.getChar(byArray, l2 + 1L) ^ UNSAFE.getChar(byArray2, l3 + 1L)) | (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l3)), 0L);
            }
            case 6: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getInt(byArray, l2 + 2L) ^ UNSAFE.getInt(byArray2, l3 + 2L)) | (long)(UNSAFE.getChar(byArray, l2) ^ UNSAFE.getChar(byArray2, l3)), 0L);
            }
            case 5: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getInt(byArray, l2 + 1L) ^ UNSAFE.getInt(byArray2, l3 + 1L)) | (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l3)), 0L);
            }
            case 4: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getInt(byArray, l2) ^ UNSAFE.getInt(byArray2, l3)), 0L);
            }
            case 3: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getChar(byArray, l2 + 1L) ^ UNSAFE.getChar(byArray2, l3 + 1L)) | (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l3)), 0L);
            }
            case 2: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getChar(byArray, l2) ^ UNSAFE.getChar(byArray2, l3)), 0L);
            }
            case 1: {
                return ConstantTimeUtils.equalsConstantTime(l | (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l3)), 0L);
            }
        }
        return ConstantTimeUtils.equalsConstantTime(l, 0L);
    }

    static int hashCodeAscii(byte[] byArray, int n, int n2) {
        int n3 = -1028477387;
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        int n4 = n2 & 7;
        long l2 = l + (long)n4;
        for (long i = l - 8L + (long)n2; i >= l2; i -= 8L) {
            n3 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i), n3);
        }
        switch (n4) {
            case 7: {
                return ((n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l + 1L))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l + 3L));
            }
            case 6: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l + 2L));
            }
            case 5: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l + 1L));
            }
            case 4: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l));
            }
            case 3: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l + 1L));
            }
            case 2: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l));
            }
            case 1: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l));
            }
        }
        return n3;
    }

    static int hashCodeAsciiCompute(long l, int n) {
        return n * 461845907 + PlatformDependent0.hashCodeAsciiSanitize((int)l) * 461845907 + (int)((l & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n) {
        return n & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s) {
        return s & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by) {
        return by & 0x1F;
    }

    static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<? super U> clazz, String string) throws Exception {
        return new UnsafeAtomicReferenceFieldUpdater(UNSAFE, clazz, string);
    }

    static <T> AtomicIntegerFieldUpdater<T> newAtomicIntegerFieldUpdater(Class<? super T> clazz, String string) throws Exception {
        return new UnsafeAtomicIntegerFieldUpdater<T>(UNSAFE, clazz, string);
    }

    static <T> AtomicLongFieldUpdater<T> newAtomicLongFieldUpdater(Class<? super T> clazz, String string) throws Exception {
        return new UnsafeAtomicLongFieldUpdater<T>(UNSAFE, clazz, string);
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long l) {
        return UNSAFE.allocateMemory(l);
    }

    static void freeMemory(long l) {
        UNSAFE.freeMemory(l);
    }

    private PlatformDependent0() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Unsafe unsafe;
        AccessibleObject accessibleObject;
        Field field;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        try {
            field = Buffer.class.getDeclaredField("address");
            field.setAccessible(true);
            if (field.getLong(byteBuffer) == 0L) {
                field = null;
            }
        }
        catch (Throwable throwable) {
            field = null;
        }
        logger.debug("java.nio.Buffer.address: {}", (Object)(field != null ? "available" : "unavailable"));
        if (field != null) {
            try {
                accessibleObject = Unsafe.class.getDeclaredField("theUnsafe");
                ((Field)accessibleObject).setAccessible(true);
                unsafe = (Unsafe)((Field)accessibleObject).get(null);
                logger.debug("sun.misc.Unsafe.theUnsafe: {}", (Object)(unsafe != null ? "available" : "unavailable"));
                try {
                    if (unsafe != null) {
                        unsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                        logger.debug("sun.misc.Unsafe.copyMemory: available");
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable");
                    throw noSuchMethodError;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable");
                    throw noSuchMethodException;
                }
            }
            catch (Throwable throwable) {
                unsafe = null;
            }
        } else {
            unsafe = null;
        }
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            UNALIGNED = false;
            DIRECT_BUFFER_CONSTRUCTOR = null;
        } else {
            boolean bl;
            long l = -1L;
            try {
                accessibleObject = byteBuffer.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                ((Constructor)accessibleObject).setAccessible(true);
                l = UNSAFE.allocateMemory(1L);
                ((Constructor)accessibleObject).newInstance(l, 1);
            }
            catch (Throwable throwable) {
                accessibleObject = null;
            }
            finally {
                if (l != -1L) {
                    UNSAFE.freeMemory(l);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = accessibleObject;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(field);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            try {
                Class<?> clazz = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                Method method = clazz.getDeclaredMethod("unaligned", new Class[0]);
                method.setAccessible(true);
                bl = Boolean.TRUE.equals(method.invoke(null, new Object[0]));
            }
            catch (Throwable throwable) {
                String string = SystemPropertyUtil.get("os.arch", "");
                bl = string.matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
            }
            UNALIGNED = bl;
            logger.debug("java.nio.Bits.unaligned: {}", (Object)UNALIGNED);
        }
        logger.debug("java.nio.DirectByteBuffer.<init>(long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        PlatformDependent0.freeDirectBuffer(byteBuffer);
    }
}

