/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakHint;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "io.netty.leakDetection.level";
    private static final Level DEFAULT_LEVEL;
    private static final String PROP_MAX_RECORDS = "io.netty.leakDetection.maxRecords";
    private static final int DEFAULT_MAX_RECORDS = 4;
    private static final int MAX_RECORDS;
    private static Level level;
    private static final InternalLogger logger;
    static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private final DefaultResourceLeak head = new DefaultResourceLeak((Object)null);
    private final DefaultResourceLeak tail = new DefaultResourceLeak((Object)null);
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = PlatformDependent.newConcurrentHashMap();
    private final String resourceType;
    private final int samplingInterval;
    private final int mask;
    private final long maxActive;
    private long active;
    private final AtomicBoolean loggedTooManyActive = new AtomicBoolean();
    private long leakCheckCnt;
    private static final String[] STACK_TRACE_ELEMENT_EXCLUSIONS;

    @Deprecated
    public static void setEnabled(boolean bl) {
        ResourceLeakDetector.setLevel(bl ? Level.SIMPLE : Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        ResourceLeakDetector.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz) {
        this(StringUtil.simpleClassName(clazz));
    }

    @Deprecated
    public ResourceLeakDetector(String string) {
        this(string, 128, Long.MAX_VALUE);
    }

    public ResourceLeakDetector(Class<?> clazz, int n, long l) {
        this(StringUtil.simpleClassName(clazz), n, l);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n, long l) {
        if (string == null) {
            throw new NullPointerException("resourceType");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("samplingInterval: " + n + " (expected: 1+)");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("maxActive: " + l + " (expected: 1+)");
        }
        this.resourceType = string;
        this.samplingInterval = MathUtil.findNextPositivePowerOfTwo(n);
        this.mask = this.samplingInterval - 1;
        this.maxActive = l;
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    public final ResourceLeak open(T t) {
        Level level = ResourceLeakDetector.level;
        if (level == Level.DISABLED) {
            return null;
        }
        if (level.ordinal() < Level.PARANOID.ordinal()) {
            if ((this.leakCheckCnt++ & (long)this.mask) == 0L) {
                this.reportLeak(level);
                return new DefaultResourceLeak(t);
            }
            return null;
        }
        this.reportLeak(level);
        return new DefaultResourceLeak(t);
    }

    private void reportLeak(Level level) {
        DefaultResourceLeak defaultResourceLeak;
        int n;
        if (!logger.isErrorEnabled()) {
            DefaultResourceLeak defaultResourceLeak2;
            while ((defaultResourceLeak2 = (DefaultResourceLeak)this.refQueue.poll()) != null) {
                defaultResourceLeak2.close();
            }
            return;
        }
        int n2 = n = level == Level.PARANOID ? 1 : this.samplingInterval;
        if (this.active * (long)n > this.maxActive && this.loggedTooManyActive.compareAndSet(false, true)) {
            this.reportInstancesLeak(this.resourceType);
        }
        while ((defaultResourceLeak = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            String string;
            defaultResourceLeak.clear();
            if (!defaultResourceLeak.close() || this.reportedLeaks.putIfAbsent(string = defaultResourceLeak.toString(), Boolean.TRUE) != null) continue;
            if (string.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
                continue;
            }
            this.reportTracedLeak(this.resourceType, string);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See http://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See http://netty.io/wiki/reference-counted-objects.html for more information.", string, PROP_LEVEL, Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    protected void reportInstancesLeak(String string) {
        logger.error("LEAK: You are creating too many " + string + " instances.  " + string + " is a shared resource that must be reused across the JVM," + "so that only a few instances are created.");
    }

    static String newRecord(Object object, int n) {
        StackTraceElement[] stackTraceElementArray;
        StringBuilder stringBuilder = new StringBuilder(4096);
        if (object != null) {
            stringBuilder.append("\tHint: ");
            if (object instanceof ResourceLeakHint) {
                stringBuilder.append(((ResourceLeakHint)object).toHintString());
            } else {
                stringBuilder.append(object);
            }
            stringBuilder.append(StringUtil.NEWLINE);
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
            if (n > 0) {
                --n;
                continue;
            }
            String string = stackTraceElement.toString();
            boolean bl = false;
            for (String string2 : STACK_TRACE_ELEMENT_EXCLUSIONS) {
                if (!string.startsWith(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append('\t');
            stringBuilder.append(string);
            stringBuilder.append(StringUtil.NEWLINE);
        }
        return stringBuilder.toString();
    }

    static {
        boolean bl;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("io.netty.noResourceLeakDetection") != null) {
            bl = SystemPropertyUtil.getBoolean("io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)DEFAULT_LEVEL.name().toLowerCase());
        } else {
            bl = false;
        }
        Level level = bl ? Level.DISABLED : DEFAULT_LEVEL;
        String string = SystemPropertyUtil.get(PROP_LEVEL_OLD, level.name()).trim().toUpperCase();
        string = SystemPropertyUtil.get(PROP_LEVEL, string).trim().toUpperCase();
        Level level2 = DEFAULT_LEVEL;
        for (Level level3 : EnumSet.allOf(Level.class)) {
            if (!string.equals(level3.name()) && !string.equals(String.valueOf(level3.ordinal()))) continue;
            level2 = level3;
        }
        MAX_RECORDS = SystemPropertyUtil.getInt(PROP_MAX_RECORDS, 4);
        ResourceLeakDetector.level = level2;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)level2.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_MAX_RECORDS, (Object)MAX_RECORDS);
        }
        STACK_TRACE_ELEMENT_EXCLUSIONS = new String[]{"io.netty.util.ReferenceCountUtil.touch(", "io.netty.buffer.AdvancedLeakAwareByteBuf.touch(", "io.netty.buffer.AbstractByteBufAllocator.toLeakAwareBuffer(", "io.netty.buffer.AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation("};
    }

    private final class DefaultResourceLeak
    extends PhantomReference<Object>
    implements ResourceLeak {
        private final String creationRecord;
        private final Deque<String> lastRecords;
        private final AtomicBoolean freed;
        private DefaultResourceLeak prev;
        private DefaultResourceLeak next;
        private int removedRecords;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DefaultResourceLeak(Object object) {
            super(object, object != null ? ResourceLeakDetector.this.refQueue : null);
            this.lastRecords = new ArrayDeque<String>();
            if (object != null) {
                Level level = ResourceLeakDetector.getLevel();
                this.creationRecord = level.ordinal() >= Level.ADVANCED.ordinal() ? ResourceLeakDetector.newRecord(null, 3) : null;
                DefaultResourceLeak defaultResourceLeak = ResourceLeakDetector.this.head;
                synchronized (defaultResourceLeak) {
                    this.prev = ResourceLeakDetector.this.head;
                    this.next = ((ResourceLeakDetector)ResourceLeakDetector.this).head.next;
                    ((ResourceLeakDetector)ResourceLeakDetector.this).head.next.prev = this;
                    ((ResourceLeakDetector)ResourceLeakDetector.this).head.next = this;
                    ResourceLeakDetector.this.active++;
                }
                this.freed = new AtomicBoolean();
            } else {
                this.creationRecord = null;
                this.freed = new AtomicBoolean(true);
            }
        }

        @Override
        public void record() {
            this.record0(null, 3);
        }

        @Override
        public void record(Object object) {
            this.record0(object, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void record0(Object object, int n) {
            if (this.creationRecord != null) {
                String string = ResourceLeakDetector.newRecord(object, n);
                Deque<String> deque = this.lastRecords;
                synchronized (deque) {
                    int n2 = this.lastRecords.size();
                    if (n2 == 0 || !this.lastRecords.getLast().equals(string)) {
                        this.lastRecords.add(string);
                    }
                    if (n2 > MAX_RECORDS) {
                        this.lastRecords.removeFirst();
                        ++this.removedRecords;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            if (this.freed.compareAndSet(false, true)) {
                DefaultResourceLeak defaultResourceLeak = ResourceLeakDetector.this.head;
                synchronized (defaultResourceLeak) {
                    ResourceLeakDetector.this.active--;
                    this.prev.next = this.next;
                    this.next.prev = this.prev;
                    this.prev = null;
                    this.next = null;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            int n;
            Object[] objectArray;
            if (this.creationRecord == null) {
                return "";
            }
            Object object = this.lastRecords;
            synchronized (object) {
                objectArray = this.lastRecords.toArray();
                n = this.removedRecords;
            }
            object = new StringBuilder(16384).append(StringUtil.NEWLINE);
            if (n > 0) {
                ((StringBuilder)object).append("WARNING: ").append(n).append(" leak records were discarded because the leak record count is limited to ").append(MAX_RECORDS).append(". Use system property ").append(ResourceLeakDetector.PROP_MAX_RECORDS).append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            ((StringBuilder)object).append("Recent access records: ").append(objectArray.length).append(StringUtil.NEWLINE);
            if (objectArray.length > 0) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ((StringBuilder)object).append('#').append(i + 1).append(':').append(StringUtil.NEWLINE).append(objectArray[i]);
                }
            }
            ((StringBuilder)object).append("Created at:").append(StringUtil.NEWLINE).append(this.creationRecord);
            ((StringBuilder)object).setLength(((StringBuilder)object).length() - StringUtil.NEWLINE.length());
            return ((StringBuilder)object).toString();
        }
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;

    }
}

