/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Handle NOOP_HANDLE = new Handle(){

        public void recycle(Object object) {
        }
    };
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private static final int OWN_THREAD_ID = ID_GENERATOR.getAndIncrement();
    private static final int DEFAULT_INITIAL_MAX_CAPACITY = 32768;
    private static final int DEFAULT_MAX_CAPACITY;
    private static final int INITIAL_CAPACITY;
    private static final int MAX_SHARED_CAPACITY_FACTOR;
    private static final int LINK_CAPACITY;
    private final int maxCapacity;
    private final int maxSharedCapacityFactor;
    private final FastThreadLocal<Stack<T>> threadLocal = new FastThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack(Recycler.this, Thread.currentThread(), Recycler.this.maxCapacity, Recycler.this.maxSharedCapacityFactor);
        }
    };
    private static final FastThreadLocal<Map<Stack<?>, WeakOrderQueue>> DELAYED_RECYCLED;

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY);
    }

    protected Recycler(int n) {
        this(n, MAX_SHARED_CAPACITY_FACTOR);
    }

    protected Recycler(int n, int n2) {
        if (n <= 0) {
            this.maxCapacity = 0;
            this.maxSharedCapacityFactor = 1;
        } else {
            this.maxCapacity = n;
            this.maxSharedCapacityFactor = Math.max(1, n2);
        }
    }

    public final T get() {
        if (this.maxCapacity == 0) {
            return this.newObject(NOOP_HANDLE);
        }
        Stack<T> stack = this.threadLocal.get();
        DefaultHandle<T> defaultHandle = stack.pop();
        if (defaultHandle == null) {
            defaultHandle = stack.newHandle();
            ((DefaultHandle)defaultHandle).value = this.newObject(defaultHandle);
        }
        return (T)((DefaultHandle)defaultHandle).value;
    }

    @Deprecated
    public final boolean recycle(T t, Handle<T> handle) {
        if (handle == NOOP_HANDLE) {
            return false;
        }
        DefaultHandle defaultHandle = (DefaultHandle)handle;
        if (((DefaultHandle)defaultHandle).stack.parent != this) {
            return false;
        }
        defaultHandle.recycle((Object)t);
        return true;
    }

    final int threadLocalCapacity() {
        return ((Stack)this.threadLocal.get()).elements.length;
    }

    final int threadLocalSize() {
        return ((Stack)this.threadLocal.get()).size;
    }

    protected abstract T newObject(Handle<T> var1);

    static /* synthetic */ AtomicInteger access$800() {
        return ID_GENERATOR;
    }

    static {
        int n = SystemPropertyUtil.getInt("io.netty.recycler.maxCapacity", 32768);
        if (n < 0) {
            n = 32768;
        }
        DEFAULT_MAX_CAPACITY = n;
        MAX_SHARED_CAPACITY_FACTOR = Math.max(2, SystemPropertyUtil.getInt("io.netty.recycler.maxSharedCapacityFactor", 2));
        LINK_CAPACITY = MathUtil.findNextPositivePowerOfTwo(Math.max(SystemPropertyUtil.getInt("io.netty.recycler.linkCapacity", 16), 16));
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacity: disabled");
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: disabled");
                logger.debug("-Dio.netty.recycler.linkCapacity: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacity: {}", (Object)DEFAULT_MAX_CAPACITY);
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: {}", (Object)MAX_SHARED_CAPACITY_FACTOR);
                logger.debug("-Dio.netty.recycler.linkCapacity: {}", (Object)LINK_CAPACITY);
            }
        }
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY, 256);
        DELAYED_RECYCLED = new FastThreadLocal<Map<Stack<?>, WeakOrderQueue>>(){

            @Override
            protected Map<Stack<?>, WeakOrderQueue> initialValue() {
                return new WeakHashMap();
            }
        };
    }

    static final class Stack<T> {
        final Recycler<T> parent;
        final Thread thread;
        private DefaultHandle<?>[] elements;
        private final int maxCapacity;
        private int size;
        final AtomicInteger availableSharedCapacity;
        private volatile WeakOrderQueue head;
        private WeakOrderQueue cursor;
        private WeakOrderQueue prev;

        Stack(Recycler<T> recycler, Thread thread, int n, int n2) {
            this.parent = recycler;
            this.thread = thread;
            this.maxCapacity = n;
            this.availableSharedCapacity = new AtomicInteger(Math.max(n / n2, LINK_CAPACITY));
            this.elements = new DefaultHandle[Math.min(INITIAL_CAPACITY, n)];
        }

        int increaseCapacity(int n) {
            int n2 = this.elements.length;
            int n3 = this.maxCapacity;
            while ((n2 <<= 1) < n && n2 < n3) {
            }
            if ((n2 = Math.min(n2, n3)) != this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, n2);
            }
            return n2;
        }

        DefaultHandle<T> pop() {
            int n = this.size;
            if (n == 0) {
                if (!this.scavenge()) {
                    return null;
                }
                n = this.size;
            }
            DefaultHandle<?> defaultHandle = this.elements[--n];
            this.elements[n] = null;
            if (((DefaultHandle)defaultHandle).lastRecycledId != ((DefaultHandle)defaultHandle).recycleId) {
                throw new IllegalStateException("recycled multiple times");
            }
            ((DefaultHandle)defaultHandle).recycleId = 0;
            ((DefaultHandle)defaultHandle).lastRecycledId = 0;
            this.size = n;
            return defaultHandle;
        }

        boolean scavenge() {
            if (this.scavengeSome()) {
                return true;
            }
            this.prev = null;
            this.cursor = this.head;
            return false;
        }

        boolean scavengeSome() {
            WeakOrderQueue weakOrderQueue;
            WeakOrderQueue weakOrderQueue2 = this.cursor;
            if (weakOrderQueue2 == null && (weakOrderQueue2 = this.head) == null) {
                return false;
            }
            boolean bl = false;
            WeakOrderQueue weakOrderQueue3 = this.prev;
            do {
                if (weakOrderQueue2.transfer(this)) {
                    bl = true;
                    break;
                }
                weakOrderQueue = weakOrderQueue2.next;
                if (weakOrderQueue2.owner.get() == null) {
                    if (weakOrderQueue2.hasFinalData()) {
                        while (weakOrderQueue2.transfer(this)) {
                            bl = true;
                        }
                    }
                    if (weakOrderQueue3 == null) continue;
                    weakOrderQueue3.next = weakOrderQueue;
                    continue;
                }
                weakOrderQueue3 = weakOrderQueue2;
            } while ((weakOrderQueue2 = weakOrderQueue) != null && !bl);
            this.prev = weakOrderQueue3;
            this.cursor = weakOrderQueue2;
            return bl;
        }

        void push(DefaultHandle<?> defaultHandle) {
            if ((((DefaultHandle)defaultHandle).recycleId | ((DefaultHandle)defaultHandle).lastRecycledId) != 0) {
                throw new IllegalStateException("recycled already");
            }
            ((DefaultHandle)defaultHandle).recycleId = (((DefaultHandle)defaultHandle).lastRecycledId = OWN_THREAD_ID);
            int n = this.size;
            if (n >= this.maxCapacity) {
                return;
            }
            if (n == this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, Math.min(n << 1, this.maxCapacity));
            }
            this.elements[n] = defaultHandle;
            this.size = n + 1;
        }

        DefaultHandle<T> newHandle() {
            return new DefaultHandle(this);
        }
    }

    private static final class WeakOrderQueue {
        private Link head;
        private Link tail;
        private WeakOrderQueue next;
        private final WeakReference<Thread> owner;
        private final int id = Recycler.access$800().getAndIncrement();
        private final AtomicInteger availableSharedCapacity;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WeakOrderQueue(Stack<?> stack, Thread thread) {
            this.head = this.tail = new Link();
            this.owner = new WeakReference<Thread>(thread);
            Stack<?> stack2 = stack;
            synchronized (stack2) {
                this.next = ((Stack)stack).head;
                ((Stack)stack).head = this;
            }
            this.availableSharedCapacity = stack.availableSharedCapacity;
        }

        static WeakOrderQueue allocate(Stack<?> stack, Thread thread) {
            return WeakOrderQueue.reserveSpace(stack.availableSharedCapacity, LINK_CAPACITY) ? new WeakOrderQueue(stack, thread) : null;
        }

        private static boolean reserveSpace(AtomicInteger atomicInteger, int n) {
            int n2;
            assert (n >= 0);
            do {
                if ((n2 = atomicInteger.get()) >= n) continue;
                return false;
            } while (!atomicInteger.compareAndSet(n2, n2 - n));
            return true;
        }

        private void reclaimSpace(int n) {
            assert (n >= 0);
            this.availableSharedCapacity.addAndGet(n);
        }

        void add(DefaultHandle<?> defaultHandle) {
            ((DefaultHandle)defaultHandle).lastRecycledId = this.id;
            Link link = this.tail;
            int n = link.get();
            if (n == LINK_CAPACITY) {
                if (!WeakOrderQueue.reserveSpace(this.availableSharedCapacity, LINK_CAPACITY)) {
                    return;
                }
                this.tail = link = (link.next = new Link());
                n = link.get();
            }
            ((Link)link).elements[n] = defaultHandle;
            ((DefaultHandle)defaultHandle).stack = null;
            link.lazySet(n + 1);
        }

        boolean hasFinalData() {
            return this.tail.readIndex != this.tail.get();
        }

        boolean transfer(Stack<?> stack) {
            Link link = this.head;
            if (link == null) {
                return false;
            }
            if (link.readIndex == LINK_CAPACITY) {
                if (link.next == null) {
                    return false;
                }
                this.head = link = link.next;
            }
            int n = link.readIndex;
            int n2 = link.get();
            int n3 = n2 - n;
            if (n3 == 0) {
                return false;
            }
            int n4 = ((Stack)stack).size;
            int n5 = n4 + n3;
            if (n5 > ((Stack)stack).elements.length) {
                int n6 = stack.increaseCapacity(n5);
                n2 = Math.min(n + n6 - n4, n2);
            }
            if (n != n2) {
                DefaultHandle[] defaultHandleArray = link.elements;
                DefaultHandle[] defaultHandleArray2 = ((Stack)stack).elements;
                int n7 = n4;
                for (int i = n; i < n2; ++i) {
                    DefaultHandle defaultHandle = defaultHandleArray[i];
                    if (defaultHandle.recycleId == 0) {
                        defaultHandle.recycleId = defaultHandle.lastRecycledId;
                    } else if (defaultHandle.recycleId != defaultHandle.lastRecycledId) {
                        throw new IllegalStateException("recycled already");
                    }
                    defaultHandle.stack = stack;
                    defaultHandleArray2[n7++] = defaultHandle;
                    defaultHandleArray[i] = null;
                }
                ((Stack)stack).size = n7;
                if (n2 == LINK_CAPACITY && link.next != null) {
                    this.reclaimSpace(LINK_CAPACITY);
                    this.head = link.next;
                }
                link.readIndex = n2;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                super.finalize();
            }
            finally {
                Link link = this.head;
                while (link != null) {
                    this.reclaimSpace(LINK_CAPACITY);
                    link = link.next;
                }
            }
        }

        private static final class Link
        extends AtomicInteger {
            private final DefaultHandle<?>[] elements = new DefaultHandle[Recycler.access$700()];
            private int readIndex;
            private Link next;

            private Link() {
            }
        }
    }

    static final class DefaultHandle<T>
    implements Handle<T> {
        private int lastRecycledId;
        private int recycleId;
        private Stack<?> stack;
        private Object value;

        DefaultHandle(Stack<?> stack) {
            this.stack = stack;
        }

        @Override
        public void recycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            Thread thread = Thread.currentThread();
            if (thread == this.stack.thread) {
                this.stack.push(this);
                return;
            }
            Map map = (Map)DELAYED_RECYCLED.get();
            WeakOrderQueue weakOrderQueue = (WeakOrderQueue)map.get(this.stack);
            if (weakOrderQueue == null) {
                weakOrderQueue = WeakOrderQueue.allocate(this.stack, thread);
                if (weakOrderQueue == null) {
                    return;
                }
                map.put(this.stack, weakOrderQueue);
            }
            weakOrderQueue.add(this);
        }
    }

    public static interface Handle<T> {
        public void recycle(T var1);
    }
}

