/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class ConstantPool<T extends Constant<T>> {
    private final Map<String, T> constants = new HashMap<String, T>();
    private int nextId = 1;

    public T valueOf(Class<?> clazz, String string) {
        if (clazz == null) {
            throw new NullPointerException("firstNameComponent");
        }
        if (string == null) {
            throw new NullPointerException("secondNameComponent");
        }
        return this.valueOf(clazz.getName() + '#' + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T valueOf(String string) {
        Object object;
        Map<String, T> map = this.constants;
        synchronized (map) {
            object = this.exists(string) ? (Constant)this.constants.get(string) : this.newInstance0(string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        this.checkNotNullAndNotEmpty(string);
        Map<String, T> map = this.constants;
        synchronized (map) {
            return this.constants.containsKey(string);
        }
    }

    public T newInstance(String string) {
        if (this.exists(string)) {
            throw new IllegalArgumentException(String.format("'%s' is already in use", string));
        }
        T t = this.newInstance0(string);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T newInstance0(String string) {
        Map<String, T> map = this.constants;
        synchronized (map) {
            T t = this.newConstant(this.nextId, string);
            this.constants.put(string, t);
            ++this.nextId;
            return t;
        }
    }

    private String checkNotNullAndNotEmpty(String string) {
        ObjectUtil.checkNotNull(string, "name");
        if (string.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        return string;
    }

    protected abstract T newConstant(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final int nextId() {
        Map<String, T> map = this.constants;
        synchronized (map) {
            int n = this.nextId++;
            return n;
        }
    }
}

