/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

final class DnsQueryContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private final DnsNameResolver parent;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final int id;
    private final DnsQuestion question;
    private final Iterable<DnsRecord> additional;
    private final DnsRecord optResource;
    private final InetSocketAddress nameServerAddr;
    private final boolean recursionDesired;
    private volatile ScheduledFuture<?> timeoutFuture;

    DnsQueryContext(DnsNameResolver dnsNameResolver, InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion, Iterable<DnsRecord> iterable, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        this.parent = ObjectUtil.checkNotNull(dnsNameResolver, "parent");
        this.nameServerAddr = ObjectUtil.checkNotNull(inetSocketAddress, "nameServerAddr");
        this.question = ObjectUtil.checkNotNull(dnsQuestion, "question");
        this.additional = ObjectUtil.checkNotNull(iterable, "additional");
        this.promise = ObjectUtil.checkNotNull(promise, "promise");
        this.recursionDesired = dnsNameResolver.isRecursionDesired();
        this.id = dnsNameResolver.queryContextManager.add(this);
        this.optResource = dnsNameResolver.isOptResourceEnabled() ? new DefaultDnsRawRecord("", DnsRecordType.OPT, dnsNameResolver.maxPayloadSize(), 0L, Unpooled.EMPTY_BUFFER) : null;
    }

    InetSocketAddress nameServerAddr() {
        return this.nameServerAddr;
    }

    DnsQuestion question() {
        return this.question;
    }

    void query() {
        DnsQuestion dnsQuestion = this.question();
        InetSocketAddress inetSocketAddress = this.nameServerAddr();
        DatagramDnsQuery datagramDnsQuery = new DatagramDnsQuery(null, inetSocketAddress, this.id);
        datagramDnsQuery.setRecursionDesired(this.recursionDesired);
        datagramDnsQuery.addRecord(DnsSection.QUESTION, dnsQuestion);
        for (DnsRecord dnsRecord : this.additional) {
            datagramDnsQuery.addRecord(DnsSection.ADDITIONAL, dnsRecord);
        }
        if (this.optResource != null) {
            datagramDnsQuery.addRecord(DnsSection.ADDITIONAL, this.optResource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: [{}: {}], {}", this.parent.ch, this.id, inetSocketAddress, dnsQuestion);
        }
        this.sendQuery(datagramDnsQuery);
    }

    private void sendQuery(final DnsQuery dnsQuery) {
        if (this.parent.channelFuture.isDone()) {
            this.writeQuery(dnsQuery);
        } else {
            this.parent.channelFuture.addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                @Override
                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        DnsQueryContext.this.writeQuery(dnsQuery);
                    } else {
                        DnsQueryContext.this.promise.tryFailure(future.cause());
                    }
                }
            });
        }
    }

    private void writeQuery(DnsQuery dnsQuery) {
        final ChannelFuture channelFuture = this.parent.ch.writeAndFlush(dnsQuery);
        if (channelFuture.isDone()) {
            this.onQueryWriteCompletion(channelFuture);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture2) throws Exception {
                    DnsQueryContext.this.onQueryWriteCompletion(channelFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.setFailure("failed to send a query", channelFuture.cause());
            return;
        }
        final long l = this.parent.queryTimeoutMillis();
        if (l > 0L) {
            this.timeoutFuture = this.parent.ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.setFailure("query timed out after " + l + " milliseconds", null);
                }
            }, l, TimeUnit.MILLISECONDS);
        }
    }

    void finish(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> addressedEnvelope) {
        DnsResponse dnsResponse = addressedEnvelope.content();
        if (dnsResponse.count(DnsSection.QUESTION) != 1) {
            logger.warn("Received a DNS response with invalid number of questions: {}", (Object)addressedEnvelope);
            return;
        }
        if (!this.question().equals(dnsResponse.recordAt(DnsSection.QUESTION))) {
            logger.warn("Received a mismatching DNS response: {}", (Object)addressedEnvelope);
            return;
        }
        this.setSuccess(addressedEnvelope);
    }

    private void setSuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> addressedEnvelope) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
        this.parent.queryContextManager.remove(this.nameServerAddr(), this.id);
        ScheduledFuture<?> scheduledFuture = this.timeoutFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        if ((promise = this.promise).setUncancellable()) {
            AddressedEnvelope<? extends DnsResponse, InetSocketAddress> addressedEnvelope2 = addressedEnvelope.retain();
            promise.setSuccess(addressedEnvelope2);
        }
    }

    private void setFailure(String string, Throwable throwable) {
        InetSocketAddress inetSocketAddress = this.nameServerAddr();
        this.parent.queryContextManager.remove(inetSocketAddress, this.id);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 64);
        stringBuilder.append('[').append(inetSocketAddress).append("] ").append(string).append(" (no stack trace available)");
        DnsNameResolverException dnsNameResolverException = throwable != null ? new DnsNameResolverException(inetSocketAddress, this.question(), stringBuilder.toString(), throwable) : new DnsNameResolverException(inetSocketAddress, this.question(), stringBuilder.toString());
        this.promise.tryFailure(dnsNameResolverException);
    }
}

