/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public final class DnsCacheEntry {
    private final String hostname;
    private final InetAddress address;
    private final Throwable cause;
    private volatile ScheduledFuture<?> expirationFuture;

    public DnsCacheEntry(String string, InetAddress inetAddress) {
        this.hostname = ObjectUtil.checkNotNull(string, "hostname");
        this.address = ObjectUtil.checkNotNull(inetAddress, "address");
        this.cause = null;
    }

    public DnsCacheEntry(String string, Throwable throwable) {
        this.hostname = ObjectUtil.checkNotNull(string, "hostname");
        this.cause = ObjectUtil.checkNotNull(throwable, "cause");
        this.address = null;
    }

    public String hostname() {
        return this.hostname;
    }

    public InetAddress address() {
        return this.address;
    }

    public Throwable cause() {
        return this.cause;
    }

    void scheduleExpiration(EventLoop eventLoop, Runnable runnable, long l, TimeUnit timeUnit) {
        assert (this.expirationFuture == null) : "expiration task scheduled already";
        this.expirationFuture = eventLoop.schedule(runnable, l, timeUnit);
    }

    void cancelExpiration() {
        ScheduledFuture<?> scheduledFuture = this.expirationFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    public String toString() {
        if (this.cause != null) {
            return this.hostname + '/' + this.cause;
        }
        return this.address.toString();
    }
}

