/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslSessionContext;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslServerSessionContext
extends OpenSslSessionContext {
    OpenSslServerSessionContext(OpenSslContext openSslContext) {
        super(openSslContext);
    }

    @Override
    public void setSessionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)n);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSLContext.getSessionCacheTimeout((long)this.context.ctx);
    }

    @Override
    public void setSessionCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheSize((long)this.context.ctx, (long)n);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSLContext.getSessionCacheSize((long)this.context.ctx);
    }

    @Override
    public void setSessionCacheEnabled(boolean bl) {
        long l = bl ? 2L : 0L;
        SSLContext.setSessionCacheMode((long)this.context.ctx, (long)l);
    }

    @Override
    public boolean isSessionCacheEnabled() {
        return SSLContext.getSessionCacheMode((long)this.context.ctx) == 2L;
    }

    public boolean setSessionIdContext(byte[] byArray) {
        return SSLContext.setSessionIdContext((long)this.context.ctx, (byte[])byArray);
    }
}

