/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslExtendedKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslServerContext
extends OpenSslContext {
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;
    private final OpenSslKeyMaterialManager keyMaterialManager;

    @Deprecated
    public OpenSslServerContext(File file, File file2) throws SSLException {
        this(file, file2, null);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string) throws SSLException {
        this(file, file2, string, null, IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, 0L, 0L);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(file, file2, string, iterable, IdentityCipherSuiteFilter.INSTANCE, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l, long l2) throws SSLException {
        this(file, file2, string, iterable, OpenSslServerContext.toApplicationProtocolConfig(iterable2), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(file, file2, string, trustManagerFactory, iterable, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) throws SSLException {
        this(null, trustManagerFactory, file, file2, string, null, iterable, null, openSslApplicationProtocolNegotiator, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(null, null, file, file2, string, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(file, trustManagerFactory, file2, file3, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(null, trustManagerFactory, file, file2, string, null, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) throws SSLException {
        this(null, trustManagerFactory, file, file2, string, null, iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) throws SSLException {
        this(OpenSslServerContext.toX509CertificatesInternal(file), trustManagerFactory, OpenSslServerContext.toX509CertificatesInternal(file2), OpenSslServerContext.toPrivateKeyInternal(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l, l2, ClientAuth.NONE);
    }

    OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2, ClientAuth clientAuth) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2, clientAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2, ClientAuth clientAuth) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l, l2, 1, (Certificate[])x509CertificateArray2, clientAuth);
        boolean bl = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                Object object;
                try {
                    SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                    if (!OpenSsl.supportsKeyManagerFactory()) {
                        if (keyManagerFactory != null) {
                            throw new IllegalArgumentException("KeyManagerFactory not supported");
                        }
                        SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                        OpenSslServerContext.setKeyMaterial(this.ctx, x509CertificateArray2, privateKey, string);
                        this.keyMaterialManager = null;
                    } else {
                        if (x509CertificateArray2 != null) {
                            keyManagerFactory = OpenSslServerContext.buildKeyManagerFactory(x509CertificateArray2, privateKey, string, keyManagerFactory);
                        }
                        this.keyMaterialManager = keyManagerFactory != null ? (OpenSslServerContext.useExtendedKeyManager((X509KeyManager)(object = OpenSslServerContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()))) ? new OpenSslExtendedKeyMaterialManager((X509ExtendedKeyManager)object, string) : new OpenSslKeyMaterialManager((X509KeyManager)object, string)) : null;
                    }
                }
                catch (Exception exception) {
                    throw new SSLException("failed to set certificate and key", exception);
                }
                try {
                    if (x509CertificateArray != null) {
                        trustManagerFactory = OpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory);
                    } else if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    }
                    object = OpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    if (OpenSslServerContext.useExtendedTrustManager((X509TrustManager)object)) {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(this.engineMap, (X509ExtendedTrustManager)object));
                    } else {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new TrustManagerVerifyCallback(this.engineMap, (X509TrustManager)object));
                    }
                }
                catch (Exception exception) {
                    throw new SSLException("unable to setup trustmanager", exception);
                }
                this.sessionContext = new OpenSslServerSessionContext(this);
                this.sessionContext.setSessionIdContext(ID);
                bl = true;
            }
        }
        finally {
            if (!bl) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    OpenSslKeyMaterialManager keyMaterialManager() {
        return this.keyMaterialManager;
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }

        @Override
        void verify(OpenSslEngine openSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkClientTrusted(x509CertificateArray, string, openSslEngine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }

        @Override
        void verify(OpenSslEngine openSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }
}

