/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.SSL;

class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialManager(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    void setKeyMaterial(OpenSslEngine openSslEngine) throws SSLException {
        String[] stringArray;
        long l = openSslEngine.sslPointer();
        for (String string : stringArray = SSL.authenticationMethods((long)l)) {
            String string2 = KEY_TYPES.get(string);
            if (string2 == null) continue;
            this.setKeyMaterial(l, this.chooseServerAlias(openSslEngine, string2));
        }
    }

    void setKeyMaterial(OpenSslEngine openSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) throws SSLException {
        this.setKeyMaterial(openSslEngine.sslPointer(), this.chooseClientAlias(openSslEngine, stringArray, x500PrincipalArray));
    }

    private void setKeyMaterial(long l, String string) throws SSLException {
        long l2 = 0L;
        long l3 = 0L;
        try {
            PrivateKey privateKey = this.keyManager.getPrivateKey(string);
            X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain(string);
            if (x509CertificateArray != null && x509CertificateArray.length != 0) {
                l3 = OpenSslContext.toBIO(this.keyManager.getCertificateChain(string));
                if (privateKey != null) {
                    l2 = OpenSslContext.toBIO(privateKey);
                }
                SSL.setCertificateBio((long)l, (long)l3, (long)l2, (String)this.password);
                SSL.setCertificateChainBio((long)l, (long)l3, (boolean)false);
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
        finally {
            if (l2 != 0L) {
                SSL.freeBIO((long)l2);
            }
            if (l3 != 0L) {
                SSL.freeBIO((long)l3);
            }
        }
    }

    protected String chooseClientAlias(OpenSslEngine openSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) {
        return this.keyManager.chooseClientAlias(stringArray, x500PrincipalArray, null);
    }

    protected String chooseServerAlias(OpenSslEngine openSslEngine, String string) {
        return this.keyManager.chooseServerAlias(string, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

