/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.util.internal.ObjectUtil;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jetty.alpn.ALPN;

final class JdkAlpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JdkAlpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.ALPNExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JdkAlpnSslEngine(SSLEngine sSLEngine, final JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        super(sSLEngine);
        ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "applicationNegotiator");
        if (bl) {
            final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), "protocolSelector");
            ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new ALPN.ServerProvider(){

                public String select(List<String> list) throws SSLException {
                    try {
                        return protocolSelector.select(list);
                    }
                    catch (SSLHandshakeException sSLHandshakeException) {
                        throw sSLHandshakeException;
                    }
                    catch (Throwable throwable) {
                        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(throwable.getMessage());
                        sSLHandshakeException.initCause(throwable);
                        throw sSLHandshakeException;
                    }
                }

                public void unsupported() {
                    protocolSelector.unsupported();
                }
            });
        } else {
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolSelectionListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
            ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new ALPN.ClientProvider(){

                public List<String> protocols() {
                    return jdkApplicationProtocolNegotiator.protocols();
                }

                public void selected(String string) throws SSLException {
                    try {
                        protocolSelectionListener.selected(string);
                    }
                    catch (SSLHandshakeException sSLHandshakeException) {
                        throw sSLHandshakeException;
                    }
                    catch (Throwable throwable) {
                        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(throwable.getMessage());
                        sSLHandshakeException.initCause(throwable);
                        throw sSLHandshakeException;
                    }
                }

                public void unsupported() {
                    protocolSelectionListener.unsupported();
                }
            });
        }
    }

    @Override
    public void closeInbound() throws SSLException {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

