/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.Queue;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    private final Http2Connection.PropertyKey stateKey;
    private final State connectionState;
    private int allocationQuantum = 1024;

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection) {
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        this.connectionState = new State(http2Stream, 16);
        http2Stream.setProperty(this.stateKey, this.connectionState);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(WeightedFairQueueByteDistributor.this.stateKey, new State(http2Stream));
            }

            @Override
            public void onWeightChanged(Http2Stream http2Stream, short s) {
                Http2Stream http2Stream2;
                if (((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)http2Stream).activeCountForTree != 0 && (http2Stream2 = http2Stream.parent()) != null) {
                    ((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)http2Stream2).totalQueuedWeights += (long)(http2Stream.weight() - s);
                }
            }

            @Override
            public void onStreamClosed(Http2Stream http2Stream) {
                WeightedFairQueueByteDistributor.this.state(http2Stream).close();
            }

            @Override
            public void onPriorityTreeParentChanged(Http2Stream http2Stream, Http2Stream http2Stream2) {
                Http2Stream http2Stream3 = http2Stream.parent();
                if (http2Stream3 != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(http2Stream);
                    if (state.activeCountForTree != 0) {
                        State state2 = WeightedFairQueueByteDistributor.this.state(http2Stream3);
                        state2.offerAndInitializePseudoTime(state);
                        state2.isActiveCountChangeForTree(state.activeCountForTree);
                    }
                }
            }

            @Override
            public void onPriorityTreeParentChanging(Http2Stream http2Stream, Http2Stream http2Stream2) {
                Http2Stream http2Stream3 = http2Stream.parent();
                if (http2Stream3 != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(http2Stream);
                    if (state.activeCountForTree != 0) {
                        State state2 = WeightedFairQueueByteDistributor.this.state(http2Stream3);
                        state2.remove(state);
                        state2.isActiveCountChangeForTree(-state.activeCountForTree);
                    }
                }
            }
        });
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        this.state(streamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamState), streamState.hasFrame() && streamState.windowSize() >= 0);
    }

    @Override
    public boolean distribute(int n, StreamByteDistributor.Writer writer) throws Http2Exception {
        int n2;
        ObjectUtil.checkNotNull(writer, "writer");
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            n2 = this.connectionState.activeCountForTree;
            n -= this.distributeToChildren(n, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (n > 0 || n2 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public void allocationQuantum(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("allocationQuantum must be > 0");
        }
        this.allocationQuantum = n;
    }

    private int distribute(int n, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        if (state.active) {
            int n2 = Math.min(n, state.streamableBytes);
            state.write(n2, writer);
            if (n2 == 0 && n != 0) {
                state.updateStreamableBytes(state.streamableBytes, false);
            }
            return n2;
        }
        return this.distributeToChildren(n, writer, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int distributeToChildren(int n, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        long l = state.totalQueuedWeights;
        State state2 = state.poll();
        State state3 = state.peek();
        try {
            assert (state3 == null || state3.pseudoTimeToWrite >= state2.pseudoTimeToWrite) : "nextChildState.pseudoTime(" + state3.pseudoTimeToWrite + ") < " + " childState.pseudoTime(" + state2.pseudoTimeToWrite + ")";
            int n2 = this.distribute(state3 == null ? n : Math.min(n, (int)Math.min((state3.pseudoTimeToWrite - state2.pseudoTimeToWrite) * (long)state2.stream.weight() / l + (long)this.allocationQuantum, Integer.MAX_VALUE)), writer, state2);
            state.pseudoTime += (long)n2;
            state2.updatePseudoTime(state, n2, l);
            int n3 = n2;
            return n3;
        }
        finally {
            if (state2.activeCountForTree != 0) {
                state.offer(state2);
            }
        }
    }

    private State state(Http2Stream http2Stream) {
        return (State)http2Stream.getProperty(this.stateKey);
    }

    int streamableBytes0(Http2Stream http2Stream) {
        return this.state((Http2Stream)http2Stream).streamableBytes;
    }

    private final class State
    implements PriorityQueueNode<State> {
        final Http2Stream stream;
        private final Queue<State> queue;
        int streamableBytes;
        int activeCountForTree;
        private int priorityQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        boolean active;

        State(Http2Stream http2Stream) {
            this(http2Stream, 0);
        }

        State(Http2Stream http2Stream, int n) {
            this.stream = http2Stream;
            this.queue = new PriorityQueue<State>(n);
        }

        void write(int n, StreamByteDistributor.Writer writer) throws Http2Exception {
            try {
                writer.write(this.stream, n);
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "byte distribution write error", new Object[0]);
            }
        }

        void isActiveCountChangeForTree(int n) {
            assert (this.activeCountForTree + n >= 0);
            this.activeCountForTree += n;
            if (!this.stream.isRoot()) {
                State state = WeightedFairQueueByteDistributor.this.state(this.stream.parent());
                if (this.activeCountForTree == 0) {
                    state.remove(this);
                } else if (this.activeCountForTree - n == 0) {
                    state.offerAndInitializePseudoTime(this);
                }
                state.isActiveCountChangeForTree(n);
            }
        }

        void updateStreamableBytes(int n, boolean bl) {
            if (this.active != bl) {
                this.isActiveCountChangeForTree(bl ? 1 : -1);
                this.active = bl;
            }
            this.streamableBytes = n;
        }

        void updatePseudoTime(State state, int n, long l) {
            assert (this.stream.id() != 0 && n >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, state.pseudoTime) + (long)n * l / (long)this.stream.weight();
        }

        void offerAndInitializePseudoTime(State state) {
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offer(state);
        }

        void offer(State state) {
            this.queue.offer(state);
            this.totalQueuedWeights += (long)state.stream.weight();
        }

        State poll() {
            State state = this.queue.poll();
            this.totalQueuedWeights -= (long)state.stream.weight();
            return state;
        }

        void remove(State state) {
            if (this.queue.remove(state)) {
                this.totalQueuedWeights -= (long)state.stream.weight();
            }
        }

        State peek() {
            return this.queue.peek();
        }

        void close() {
            this.updateStreamableBytes(0, false);
        }

        @Override
        public int compareTo(State state) {
            return MathUtil.compare(this.pseudoTimeToWrite, state.pseudoTimeToWrite);
        }

        @Override
        public int priorityQueueIndex() {
            return this.priorityQueueIndex;
        }

        @Override
        public void priorityQueueIndex(int n) {
            this.priorityQueueIndex = n;
        }
    }
}

