/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2StreamActiveEvent;
import io.netty.handler.codec.http2.Http2StreamClosedEvent;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public final class Http2MultiplexCodec
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2MultiplexCodec.class);
    private final ChannelHandler streamHandler;
    private final EventLoopGroup streamGroup;
    private final List<Http2StreamChannel> channelsToFireChildReadComplete = new ArrayList<Http2StreamChannel>();
    private final boolean server;
    private ChannelHandlerContext ctx;
    private volatile Runnable flushTask;
    private final IntObjectMap<Http2StreamChannel> childChannels = new IntObjectHashMap<Http2StreamChannel>();

    public Http2MultiplexCodec(boolean bl, EventLoopGroup eventLoopGroup, ChannelHandler channelHandler) {
        if (!channelHandler.getClass().isAnnotationPresent(ChannelHandler.Sharable.class)) {
            throw new IllegalArgumentException("streamHandler must be Sharable");
        }
        this.server = bl;
        this.streamHandler = channelHandler;
        this.streamGroup = eventLoopGroup;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (!(throwable instanceof Http2Exception.StreamException)) {
            channelHandlerContext.fireExceptionCaught(throwable);
            return;
        }
        Http2Exception.StreamException streamException = (Http2Exception.StreamException)throwable;
        try {
            Http2StreamChannel http2StreamChannel = this.childChannels.get(streamException.streamId());
            if (http2StreamChannel != null) {
                http2StreamChannel.pipeline().fireExceptionCaught(streamException);
            } else {
                logger.warn(String.format("Exception caught for unknown HTTP/2 stream '%d'", streamException.streamId()), streamException);
            }
        }
        finally {
            this.onStreamClosed(streamException.streamId());
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (!(object instanceof Http2Frame)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        if (object instanceof Http2StreamFrame) {
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)object;
            int n = http2StreamFrame.streamId();
            Http2StreamChannel http2StreamChannel = this.childChannels.get(n);
            if (http2StreamChannel == null) {
                ReferenceCountUtil.release(object);
                throw new Http2Exception.StreamException(n, Http2Error.STREAM_CLOSED, String.format("Received %s frame for an unknown stream %d", http2StreamFrame.name(), n));
            }
            this.fireChildReadAndRegister(http2StreamChannel, http2StreamFrame);
        } else if (object instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame http2GoAwayFrame = (Http2GoAwayFrame)object;
            for (IntObjectMap.PrimitiveEntry<Http2StreamChannel> primitiveEntry : this.childChannels.entries()) {
                Http2StreamChannel http2StreamChannel = primitiveEntry.value();
                int n = primitiveEntry.key();
                if (n <= http2GoAwayFrame.lastStreamId() || !this.isLocalStream(n)) continue;
                http2StreamChannel.pipeline().fireUserEventTriggered(http2GoAwayFrame.retainedDuplicate());
            }
            http2GoAwayFrame.release();
        } else {
            ReferenceCountUtil.release(object);
            throw new UnsupportedMessageTypeException(object, new Class[0]);
        }
    }

    private void fireChildReadAndRegister(Http2StreamChannel http2StreamChannel, Http2StreamFrame http2StreamFrame) {
        http2StreamChannel.fireChildRead(http2StreamFrame);
        if (!http2StreamChannel.inStreamsToFireChildReadComplete) {
            this.channelsToFireChildReadComplete.add(http2StreamChannel);
            http2StreamChannel.inStreamsToFireChildReadComplete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        block6: {
            if (!(object instanceof Http2StreamStateEvent)) {
                channelHandlerContext.fireUserEventTriggered(object);
                return;
            }
            try {
                int n = ((Http2StreamStateEvent)object).streamId();
                if (object instanceof Http2StreamActiveEvent) {
                    this.onStreamActive(n);
                    break block6;
                }
                if (object instanceof Http2StreamClosedEvent) {
                    this.onStreamClosed(n);
                    break block6;
                }
                throw new UnsupportedMessageTypeException(object, new Class[0]);
            }
            finally {
                ReferenceCountUtil.release(object);
            }
        }
    }

    private void onStreamActive(int n) {
        ChannelFuture channelFuture = this.createStreamChannel(this.ctx, n, this.streamHandler);
        Http2StreamChannel http2StreamChannel = (Http2StreamChannel)channelFuture.channel();
        Http2StreamChannel http2StreamChannel2 = this.childChannels.put(n, http2StreamChannel);
        assert (http2StreamChannel2 == null);
    }

    private void onStreamClosed(int n) {
        final Http2StreamChannel http2StreamChannel = this.childChannels.remove(n);
        if (http2StreamChannel != null) {
            EventLoop eventLoop = http2StreamChannel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.onStreamClosed0(http2StreamChannel);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.onStreamClosed0(http2StreamChannel);
                    }
                });
            }
        }
    }

    private void onStreamClosed0(Http2StreamChannel http2StreamChannel) {
        assert (http2StreamChannel.eventLoop().inEventLoop());
        http2StreamChannel.onStreamClosedFired = true;
        http2StreamChannel.fireChildRead(AbstractHttp2StreamChannel.CLOSE_MESSAGE);
    }

    void flushFromStreamChannel() {
        EventExecutor eventExecutor = this.ctx.executor();
        if (eventExecutor.inEventLoop()) {
            this.flush(this.ctx);
        } else {
            Runnable runnable = this.flushTask;
            if (runnable == null) {
                runnable = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.flush(Http2MultiplexCodec.this.ctx);
                    }
                };
            }
            eventExecutor.execute(runnable);
        }
    }

    void writeFromStreamChannel(final Object object, final boolean bl) {
        final ChannelPromise channelPromise = this.ctx.newPromise();
        EventExecutor eventExecutor = this.ctx.executor();
        if (eventExecutor.inEventLoop()) {
            this.writeFromStreamChannel0(object, bl, channelPromise);
        } else {
            try {
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.writeFromStreamChannel0(object, bl, channelPromise);
                    }
                });
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
    }

    private void writeFromStreamChannel0(Object object, boolean bl, ChannelPromise channelPromise) {
        try {
            this.write(this.ctx, object, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        if (bl) {
            this.flush(this.ctx);
        }
    }

    private ChannelFuture createStreamChannel(ChannelHandlerContext channelHandlerContext, int n, ChannelHandler channelHandler) {
        EventLoopGroup eventLoopGroup = this.streamGroup != null ? this.streamGroup : channelHandlerContext.channel().eventLoop();
        Http2StreamChannel http2StreamChannel = new Http2StreamChannel(n);
        http2StreamChannel.pipeline().addLast(channelHandler);
        ChannelFuture channelFuture = eventLoopGroup.register(http2StreamChannel);
        if (channelFuture.cause() != null) {
            if (http2StreamChannel.isRegistered()) {
                http2StreamChannel.close();
            } else {
                http2StreamChannel.unsafe().closeForcibly();
            }
        }
        return channelFuture;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        for (int i = 0; i < this.channelsToFireChildReadComplete.size(); ++i) {
            Http2StreamChannel http2StreamChannel = this.channelsToFireChildReadComplete.get(i);
            http2StreamChannel.inStreamsToFireChildReadComplete = false;
            http2StreamChannel.fireChildReadComplete();
        }
        this.channelsToFireChildReadComplete.clear();
    }

    private boolean isLocalStream(int n) {
        boolean bl = (n & 1) == 0;
        return n > 0 && this.server == bl;
    }

    final class Http2StreamChannel
    extends AbstractHttp2StreamChannel {
        private final int streamId;
        boolean onStreamClosedFired;
        boolean inStreamsToFireChildReadComplete;

        Http2StreamChannel(int n) {
            super(Http2MultiplexCodec.this.ctx.channel());
            this.streamId = n;
        }

        @Override
        protected void doClose() throws Exception {
            if (!this.onStreamClosedFired) {
                DefaultHttp2ResetFrame defaultHttp2ResetFrame = new DefaultHttp2ResetFrame(Http2Error.CANCEL).setStreamId(this.streamId);
                Http2MultiplexCodec.this.writeFromStreamChannel(defaultHttp2ResetFrame, true);
            }
            super.doClose();
        }

        @Override
        protected void doWrite(Object object) {
            if (!(object instanceof Http2StreamFrame)) {
                ReferenceCountUtil.release(object);
                throw new IllegalArgumentException("Message must be an Http2StreamFrame: " + object);
            }
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)object;
            if (http2StreamFrame.streamId() != -1) {
                ReferenceCountUtil.release(http2StreamFrame);
                throw new IllegalArgumentException("Stream must not be set on the frame");
            }
            http2StreamFrame.setStreamId(this.streamId);
            Http2MultiplexCodec.this.writeFromStreamChannel(object, false);
        }

        @Override
        protected void doWriteComplete() {
            Http2MultiplexCodec.this.flushFromStreamChannel();
        }

        @Override
        protected EventExecutor preferredEventExecutor() {
            return Http2MultiplexCodec.this.ctx.executor();
        }

        @Override
        protected void bytesConsumed(int n) {
            Http2MultiplexCodec.this.ctx.write(new DefaultHttp2WindowUpdateFrame(n).setStreamId(this.streamId));
        }
    }
}

