/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Http2ConnectionHandler
extends ByteToMessageDecoder
implements Http2LifecycleManager,
ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2ConnectionHandler.class);
    private final Http2ConnectionDecoder decoder;
    private final Http2ConnectionEncoder encoder;
    private final Http2Settings initialSettings;
    private ChannelFutureListener closeListener;
    private BaseDecoder byteDecoder;
    private long gracefulShutdownTimeoutMillis;

    protected Http2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        this.initialSettings = ObjectUtil.checkNotNull(http2Settings, "initialSettings");
        this.decoder = ObjectUtil.checkNotNull(http2ConnectionDecoder, "decoder");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        if (http2ConnectionEncoder.connection() != http2ConnectionDecoder.connection()) {
            throw new IllegalArgumentException("Encoder and Decoder do not share the same connection object");
        }
    }

    public long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    public void gracefulShutdownTimeoutMillis(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + l + " (expected: >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = l;
    }

    public Http2Connection connection() {
        return this.encoder.connection();
    }

    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    private boolean prefaceSent() {
        return this.byteDecoder != null && this.byteDecoder.prefaceSent();
    }

    public void onHttpClientUpgrade() throws Http2Exception {
        if (this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client-side HTTP upgrade requested for a server", new Object[0]);
        }
        if (this.prefaceSent() || this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is sent or received", new Object[0]);
        }
        this.connection().local().createStream(1, true);
    }

    public void onHttpServerUpgrade(Http2Settings http2Settings) throws Http2Exception {
        if (!this.connection().isServer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server-side HTTP upgrade requested for a client", new Object[0]);
        }
        if (this.prefaceSent() || this.decoder.prefaceReceived()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP upgrade must occur before HTTP/2 preface is sent or received", new Object[0]);
        }
        this.encoder.remoteSettings(http2Settings);
        this.connection().remote().createStream(1, true);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
        this.encoder.flowController().writePendingBytes();
        try {
            channelHandlerContext.flush();
        }
        catch (Throwable throwable) {
            throw new Http2Exception(Http2Error.INTERNAL_ERROR, "Error flushing", throwable);
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.encoder.lifecycleManager(this);
        this.decoder.lifecycleManager(this);
        this.encoder.flowController().channelHandlerContext(channelHandlerContext);
        this.decoder.flowController().channelHandlerContext(channelHandlerContext);
        this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.byteDecoder != null) {
            this.byteDecoder.handlerRemoved(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.byteDecoder == null) {
            this.byteDecoder = new PrefaceDecoder(channelHandlerContext);
        }
        this.byteDecoder.channelActive(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelInactive(channelHandlerContext);
        if (this.byteDecoder != null) {
            this.byteDecoder.channelInactive(channelHandlerContext);
            this.byteDecoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            if (channelHandlerContext.channel().isWritable()) {
                this.flush(channelHandlerContext);
            }
            this.encoder.flowController().channelWritabilityChanged();
        }
        finally {
            super.channelWritabilityChanged(channelHandlerContext);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ChannelFuture channelFuture = this.connection().goAwaySent() ? channelHandlerContext.write(Unpooled.EMPTY_BUFFER) : this.goAway(channelHandlerContext, null);
        channelHandlerContext.flush();
        this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
    }

    private void doGracefulShutdown(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        if (this.isGracefulShutdownComplete()) {
            channelFuture.addListener(new ClosingChannelFutureListener(channelHandlerContext, channelPromise));
        } else {
            this.closeListener = new ClosingChannelFutureListener(channelHandlerContext, channelPromise, this.gracefulShutdownTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.write(object, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.flush(channelHandlerContext);
        }
        finally {
            super.channelReadComplete(channelHandlerContext);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (Http2CodecUtil.getEmbeddedHttp2Exception(throwable) != null) {
            this.onError(channelHandlerContext, throwable);
        } else {
            super.exceptionCaught(channelHandlerContext, throwable);
        }
    }

    @Override
    public void closeStreamLocal(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case HALF_CLOSED_LOCAL: 
            case OPEN: {
                http2Stream.closeLocalSide();
                break;
            }
            default: {
                this.closeStream(http2Stream, channelFuture);
            }
        }
    }

    @Override
    public void closeStreamRemote(Http2Stream http2Stream, ChannelFuture channelFuture) {
        switch (http2Stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                http2Stream.closeRemoteSide();
                break;
            }
            default: {
                this.closeStream(http2Stream, channelFuture);
            }
        }
    }

    @Override
    public void closeStream(Http2Stream http2Stream, ChannelFuture channelFuture) {
        http2Stream.close();
        if (channelFuture.isDone()) {
            this.checkCloseConnection(channelFuture);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    Http2ConnectionHandler.this.checkCloseConnection(channelFuture);
                }
            });
        }
    }

    @Override
    public void onError(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        Http2Exception http2Exception = Http2CodecUtil.getEmbeddedHttp2Exception(throwable);
        if (Http2Exception.isStreamError(http2Exception)) {
            this.onStreamError(channelHandlerContext, throwable, (Http2Exception.StreamException)http2Exception);
        } else if (http2Exception instanceof Http2Exception.CompositeStreamException) {
            Http2Exception.CompositeStreamException compositeStreamException = (Http2Exception.CompositeStreamException)http2Exception;
            for (Http2Exception.StreamException streamException : compositeStreamException) {
                this.onStreamError(channelHandlerContext, throwable, streamException);
            }
        } else {
            this.onConnectionError(channelHandlerContext, throwable, http2Exception);
        }
        channelHandlerContext.flush();
    }

    protected boolean isGracefulShutdownComplete() {
        return this.connection().numActiveStreams() == 0;
    }

    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception http2Exception) {
        if (http2Exception == null) {
            http2Exception = new Http2Exception(Http2Error.INTERNAL_ERROR, throwable.getMessage(), throwable);
        }
        ChannelPromise channelPromise = channelHandlerContext.newPromise();
        ChannelFuture channelFuture = this.goAway(channelHandlerContext, http2Exception);
        switch (http2Exception.shutdownHint()) {
            case GRACEFUL_SHUTDOWN: {
                this.doGracefulShutdown(channelHandlerContext, channelFuture, channelPromise);
                break;
            }
            default: {
                channelFuture.addListener(new ClosingChannelFutureListener(channelHandlerContext, channelPromise));
            }
        }
    }

    protected void onStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception.StreamException streamException) {
        this.resetStream(channelHandlerContext, streamException.streamId(), streamException.error().code(), channelHandlerContext.newPromise());
    }

    protected Http2FrameWriter frameWriter() {
        return this.encoder().frameWriter();
    }

    @Override
    public ChannelFuture resetStream(final ChannelHandlerContext channelHandlerContext, int n, long l, ChannelPromise channelPromise) {
        final Http2Stream http2Stream = this.connection().stream(n);
        if (http2Stream == null || http2Stream.isResetSent()) {
            return channelPromise.setSuccess();
        }
        ChannelFuture channelFuture = http2Stream.state() == Http2Stream.State.IDLE ? channelPromise.setSuccess() : this.frameWriter().writeRstStream(channelHandlerContext, n, l, channelPromise);
        http2Stream.resetSent();
        if (channelFuture.isDone()) {
            this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    Http2ConnectionHandler.this.processRstStreamWriteResult(channelHandlerContext, http2Stream, channelFuture);
                }
            });
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture goAway(final ChannelHandlerContext channelHandlerContext, final int n, final long l, final ByteBuf byteBuf, ChannelPromise channelPromise) {
        try {
            Http2Connection http2Connection = this.connection();
            if (http2Connection.goAwaySent() && n > http2Connection.remote().lastStreamKnownByPeer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Last stream identifier must not increase between sending multiple GOAWAY frames (was '%d', is '%d').", http2Connection.remote().lastStreamKnownByPeer(), n);
            }
            http2Connection.goAwaySent(n, l, byteBuf);
            byteBuf.retain();
            ChannelFuture channelFuture = this.frameWriter().writeGoAway(channelHandlerContext, n, l, byteBuf, channelPromise);
            if (channelFuture.isDone()) {
                Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n, l, byteBuf, channelFuture);
            } else {
                channelFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        Http2ConnectionHandler.processGoAwayWriteResult(channelHandlerContext, n, l, byteBuf, channelFuture);
                    }
                });
            }
            return channelFuture;
        }
        catch (Throwable throwable) {
            byteBuf.release();
            return channelPromise.setFailure(throwable);
        }
    }

    private void checkCloseConnection(ChannelFuture channelFuture) {
        if (this.closeListener != null && this.isGracefulShutdownComplete()) {
            ChannelFutureListener channelFutureListener = this.closeListener;
            this.closeListener = null;
            try {
                channelFutureListener.operationComplete(channelFuture);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Close listener threw an unexpected exception", exception);
            }
        }
    }

    private ChannelFuture goAway(ChannelHandlerContext channelHandlerContext, Http2Exception http2Exception) {
        long l = http2Exception != null ? http2Exception.error().code() : Http2Error.NO_ERROR.code();
        int n = this.connection().remote().lastStreamCreated();
        return this.goAway(channelHandlerContext, n, l, Http2CodecUtil.toByteBuf(channelHandlerContext, http2Exception), channelHandlerContext.newPromise());
    }

    private void processRstStreamWriteResult(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, ChannelFuture channelFuture) {
        if (channelFuture.isSuccess()) {
            this.closeStream(http2Stream, channelFuture);
        } else {
            this.onConnectionError(channelHandlerContext, channelFuture.cause(), null);
        }
    }

    private static ByteBuf clientPrefaceString(Http2Connection http2Connection) {
        return http2Connection.isServer() ? Http2CodecUtil.connectionPrefaceBuf() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processGoAwayWriteResult(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf, ChannelFuture channelFuture) {
        try {
            if (channelFuture.isSuccess()) {
                if (l != Http2Error.NO_ERROR.code()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} Sent GOAWAY: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n, l, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                    }
                    channelHandlerContext.close();
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Sending GOAWAY failed: lastStreamId '{}', errorCode '{}', debugData '{}'. Forcing shutdown of the connection.", channelHandlerContext.channel(), n, l, byteBuf.toString(CharsetUtil.UTF_8), channelFuture.cause());
                }
                channelHandlerContext.close();
            }
        }
        finally {
            byteBuf.release();
        }
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        private final ScheduledFuture<?> timeoutTask;

        ClosingChannelFutureListener(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = null;
        }

        ClosingChannelFutureListener(final ChannelHandlerContext channelHandlerContext, final ChannelPromise channelPromise, long l, TimeUnit timeUnit) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
            this.timeoutTask = channelHandlerContext.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.close(channelPromise);
                }
            }, l, timeUnit);
        }

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            this.ctx.close(this.promise);
        }
    }

    private final class FrameDecoder
    extends BaseDecoder {
        private FrameDecoder() {
        }

        @Override
        public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            try {
                Http2ConnectionHandler.this.decoder.decodeFrame(channelHandlerContext, byteBuf, list);
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, throwable);
            }
        }
    }

    private final class PrefaceDecoder
    extends BaseDecoder {
        private ByteBuf clientPrefaceString;
        private boolean prefaceSent;

        public PrefaceDecoder(ChannelHandlerContext channelHandlerContext) {
            this.clientPrefaceString = Http2ConnectionHandler.clientPrefaceString(Http2ConnectionHandler.this.encoder.connection());
            this.sendPreface(channelHandlerContext);
        }

        @Override
        public boolean prefaceSent() {
            return this.prefaceSent;
        }

        @Override
        public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            try {
                if (channelHandlerContext.channel().isActive() && this.readClientPrefaceString(byteBuf) && this.verifyFirstFrameIsSettings(byteBuf)) {
                    Http2ConnectionHandler.this.byteDecoder = new FrameDecoder();
                    Http2ConnectionHandler.this.byteDecoder.decode(channelHandlerContext, byteBuf, list);
                }
            }
            catch (Throwable throwable) {
                Http2ConnectionHandler.this.onError(channelHandlerContext, throwable);
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.sendPreface(channelHandlerContext);
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.cleanup();
            super.channelInactive(channelHandlerContext);
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.cleanup();
        }

        private void cleanup() {
            if (this.clientPrefaceString != null) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
            }
        }

        private boolean readClientPrefaceString(ByteBuf byteBuf) throws Http2Exception {
            if (this.clientPrefaceString == null) {
                return true;
            }
            int n = this.clientPrefaceString.readableBytes();
            int n2 = Math.min(byteBuf.readableBytes(), n);
            if (n2 == 0 || !ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), this.clientPrefaceString, this.clientPrefaceString.readerIndex(), n2)) {
                String string = ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), Math.min(byteBuf.readableBytes(), this.clientPrefaceString.readableBytes()));
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 client preface string missing or corrupt. Hex dump for received bytes: %s", string);
            }
            byteBuf.skipBytes(n2);
            this.clientPrefaceString.skipBytes(n2);
            if (!this.clientPrefaceString.isReadable()) {
                this.clientPrefaceString.release();
                this.clientPrefaceString = null;
                return true;
            }
            return false;
        }

        private boolean verifyFirstFrameIsSettings(ByteBuf byteBuf) throws Http2Exception {
            if (byteBuf.readableBytes() < 5) {
                return false;
            }
            short s = byteBuf.getUnsignedByte(byteBuf.readerIndex() + 3);
            short s2 = byteBuf.getUnsignedByte(byteBuf.readerIndex() + 4);
            if (s != 4 || (s2 & 1) != 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "First received frame was not SETTINGS. Hex dump for first 5 bytes: %s", ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), 5));
            }
            return true;
        }

        private void sendPreface(ChannelHandlerContext channelHandlerContext) {
            if (this.prefaceSent || !channelHandlerContext.channel().isActive()) {
                return;
            }
            this.prefaceSent = true;
            if (!Http2ConnectionHandler.this.connection().isServer()) {
                channelHandlerContext.write(Http2CodecUtil.connectionPrefaceBuf()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            Http2ConnectionHandler.this.encoder.writeSettings(channelHandlerContext, Http2ConnectionHandler.this.initialSettings, channelHandlerContext.newPromise()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    private abstract class BaseDecoder {
        private BaseDecoder() {
        }

        public abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        }

        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            Http2ConnectionHandler.this.encoder().close();
            Http2ConnectionHandler.this.decoder().close();
            Http2ConnectionHandler.this.connection().close(channelHandlerContext.voidPromise());
        }

        public boolean prefaceSent() {
            return true;
        }
    }
}

