/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostMultipartRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        if (httpDataFactory == null) {
            throw new NullPointerException("factory");
        }
        if (httpRequest == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.request = httpRequest;
        this.charset = charset;
        this.factory = httpDataFactory;
        this.setMultipart(this.request.headers().get(HttpHeaderNames.CONTENT_TYPE));
        if (httpRequest instanceof HttpContent) {
            this.offer((HttpContent)((Object)httpRequest));
        } else {
            this.undecodedChunk = Unpooled.buffer();
            this.parseBody();
        }
    }

    private void setMultipart(String string) {
        String[] stringArray = HttpPostRequestDecoder.getMultipartDataBoundary(string);
        if (stringArray != null) {
            this.multipartDataBoundary = stringArray[0];
            if (stringArray.length > 1 && stringArray[1] != null) {
                this.charset = Charset.forName(stringArray[1]);
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("discardThreshold must be >= 0");
        }
        this.discardThreshold = n;
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.copy();
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            this.undecodedChunk.discardReadBytes();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        InterfaceHttpData interfaceHttpData = this.decodeMultipart(this.currentStatus);
        while (interfaceHttpData != null) {
            this.addHttpData(interfaceHttpData);
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) break;
            interfaceHttpData = this.decodeMultipart(this.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder.MultiPartStatus multiPartStatus) {
        switch (multiPartStatus) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                return this.findMultipartDelimiter(this.multipartDataBoundary, HttpPostRequestDecoder.MultiPartStatus.DISPOSITION, HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                Attribute attribute;
                Charset charset = null;
                Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (attribute2 != null) {
                    try {
                        charset = Charset.forName(attribute2.getValue());
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(unsupportedCharsetException);
                    }
                }
                Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    long l;
                    attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        l = attribute != null ? Long.parseLong(attribute.getValue()) : 0L;
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        l = 0L;
                    }
                    try {
                        this.currentAttribute = l > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()), l) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                    }
                    if (charset != null) {
                        this.currentAttribute.setCharset(charset);
                    }
                }
                try {
                    this.loadFieldMultipart(this.multipartDataBoundary);
                }
                catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
                    return null;
                }
                attribute = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                return attribute;
            }
            case FILEUPLOAD: {
                return this.getFileUpload(this.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                return this.findMultipartDelimiter(this.multipartMixedBoundary, HttpPostRequestDecoder.MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                return this.getFileUpload(this.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Shouldn't reach here.");
    }

    void skipControlCharacters() {
        HttpPostBodyUtil.SeekAheadOptimize seekAheadOptimize;
        try {
            seekAheadOptimize = new HttpPostBodyUtil.SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil.SeekAheadNoBackArrayException seekAheadNoBackArrayException) {
            try {
                this.skipControlCharactersStandard();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
            return;
        }
        while (seekAheadOptimize.pos < seekAheadOptimize.limit) {
            char c;
            if (Character.isISOControl(c = (char)(seekAheadOptimize.bytes[seekAheadOptimize.pos++] & 0xFF)) || Character.isWhitespace(c)) continue;
            seekAheadOptimize.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Access out of bounds");
    }

    void skipControlCharactersStandard() {
        char c;
        while (Character.isISOControl(c = (char)this.undecodedChunk.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
    }

    private InterfaceHttpData findMultipartDelimiter(String string, HttpPostRequestDecoder.MultiPartStatus multiPartStatus, HttpPostRequestDecoder.MultiPartStatus multiPartStatus2) {
        String string2;
        int n = this.undecodedChunk.readerIndex();
        try {
            this.skipControlCharacters();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        this.skipOneLine();
        try {
            string2 = this.readDelimiter(string);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        if (string2.equals(string)) {
            this.currentStatus = multiPartStatus;
            return this.decodeMultipart(multiPartStatus);
        }
        if (string2.equals(string + "--")) {
            this.currentStatus = multiPartStatus2;
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        Object object;
        int n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Object object2;
            try {
                this.skipControlCharacters();
                object = this.readLine();
            }
            catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(n);
                return null;
            }
            String[] stringArray = HttpPostMultipartRequestDecoder.splitMultipartHeader((String)object);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase(stringArray[0])) {
                boolean bl;
                if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                    bl = HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase(stringArray[1]);
                } else {
                    boolean bl2 = bl = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase(stringArray[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase(stringArray[1]);
                }
                if (!bl) continue;
                for (int i = 2; i < stringArray.length; ++i) {
                    Attribute attribute;
                    object2 = StringUtil.split(stringArray[i], '=', 2);
                    try {
                        String string = HttpPostMultipartRequestDecoder.cleanString(object2[0]);
                        String string2 = object2[1];
                        string2 = HttpHeaderValues.FILENAME.contentEquals(string) ? string2.substring(1, string2.length() - 1) : HttpPostMultipartRequestDecoder.cleanString(string2);
                        attribute = this.factory.createAttribute(this.request, string, string2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(attribute.getName(), attribute);
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_LENGTH, attribute);
                continue;
            }
            if (HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase(stringArray[0])) {
                if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase(stringArray[1])) {
                    if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                        String string = StringUtil.substringAfter(stringArray[2], '=');
                        this.multipartMixedBoundary = "--" + string;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                        return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER);
                    }
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    Object object3;
                    if (stringArray[i].toLowerCase().startsWith(HttpHeaderValues.CHARSET.toString())) {
                        object3 = StringUtil.substringAfter(stringArray[i], '=');
                        try {
                            object2 = this.factory.createAttribute(this.request, HttpHeaderValues.CHARSET.toString(), HttpPostMultipartRequestDecoder.cleanString((String)object3));
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                        }
                        this.currentFieldAttributes.put(HttpHeaderValues.CHARSET, (Attribute)object2);
                        continue;
                    }
                    try {
                        object3 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(stringArray[0]), stringArray[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(object3.getName(), (Attribute)object3);
                }
                continue;
            }
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("Unknown Params: " + (String)object);
        }
        object = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            if (object != null) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FIELD);
        }
        if (object != null) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Filename not found");
    }

    protected InterfaceHttpData getFileUpload(String string) {
        HttpData httpData;
        Object object;
        Attribute attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset charset = this.charset;
        HttpPostBodyUtil.TransferEncodingMechanism transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT7;
        if (attribute != null) {
            try {
                object = attribute.getValue().toLowerCase();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT7.value())) {
                charset = CharsetUtil.US_ASCII;
            } else if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT8.value())) {
                charset = CharsetUtil.ISO_8859_1;
                transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT8;
            } else if (((String)object).equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                transferEncodingMechanism = HttpPostBodyUtil.TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("TransferEncoding Unknown: " + (String)object);
            }
        }
        if ((object = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                charset = Charset.forName(object.getValue());
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(unsupportedCharsetException);
            }
        }
        if (this.currentFileUpload == null) {
            long l;
            httpData = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute attribute4 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                l = attribute4 != null ? Long.parseLong(attribute4.getValue()) : 0L;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            try {
                String string2 = attribute3 != null ? attribute3.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute2.getValue()), HttpPostMultipartRequestDecoder.cleanString(httpData.getValue()), string2, transferEncodingMechanism.value(), charset, l);
            }
            catch (NullPointerException nullPointerException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(nullPointerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        }
        try {
            this.readFileUploadByteMultipart(string);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            httpData = this.currentFileUpload;
            this.currentFileUpload = null;
            return httpData;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.checkDestroyed();
        this.cleanFiles();
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
        for (int i = this.bodyListHttpDataRank; i < this.bodyListHttpData.size(); ++i) {
            this.bodyListHttpData.get(i).release();
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);
        this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
    }

    private String readLineStandard() {
        int n = this.undecodedChunk.readerIndex();
        try {
            ByteBuf byteBuf = Unpooled.buffer(64);
            while (this.undecodedChunk.isReadable()) {
                byte by = this.undecodedChunk.readByte();
                if (by == 13) {
                    by = this.undecodedChunk.getByte(this.undecodedChunk.readerIndex());
                    if (by == 10) {
                        this.undecodedChunk.readByte();
                        return byteBuf.toString(this.charset);
                    }
                    byteBuf.writeByte(13);
                    continue;
                }
                if (by == 10) {
                    return byteBuf.toString(this.charset);
                }
                byteBuf.writeByte(by);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private String readLine() {
        HttpPostBodyUtil.SeekAheadOptimize seekAheadOptimize;
        try {
            seekAheadOptimize = new HttpPostBodyUtil.SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil.SeekAheadNoBackArrayException seekAheadNoBackArrayException) {
            return this.readLineStandard();
        }
        int n = this.undecodedChunk.readerIndex();
        try {
            ByteBuf byteBuf = Unpooled.buffer(64);
            while (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                byte by;
                if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 13) {
                    if (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                        if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                            seekAheadOptimize.setReadPosition(0);
                            return byteBuf.toString(this.charset);
                        }
                        --seekAheadOptimize.pos;
                        byteBuf.writeByte(13);
                        continue;
                    }
                    byteBuf.writeByte(by);
                    continue;
                }
                if (by == 10) {
                    seekAheadOptimize.setReadPosition(0);
                    return byteBuf.toString(this.charset);
                }
                byteBuf.writeByte(by);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private String readDelimiterStandard(String string) {
        int n = this.undecodedChunk.readerIndex();
        try {
            byte by;
            StringBuilder stringBuilder = new StringBuilder(64);
            int n2 = string.length();
            for (int i = 0; this.undecodedChunk.isReadable() && i < n2; ++i) {
                by = this.undecodedChunk.readByte();
                if (by == string.charAt(i)) {
                    stringBuilder.append((char)by);
                    continue;
                }
                this.undecodedChunk.readerIndex(n);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            if (this.undecodedChunk.isReadable()) {
                by = this.undecodedChunk.readByte();
                if (by == 13) {
                    by = this.undecodedChunk.readByte();
                    if (by == 10) {
                        return stringBuilder.toString();
                    }
                    this.undecodedChunk.readerIndex(n);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                if (by == 10) {
                    return stringBuilder.toString();
                }
                if (by == 45) {
                    stringBuilder.append('-');
                    by = this.undecodedChunk.readByte();
                    if (by == 45) {
                        stringBuilder.append('-');
                        if (this.undecodedChunk.isReadable()) {
                            by = this.undecodedChunk.readByte();
                            if (by == 13) {
                                by = this.undecodedChunk.readByte();
                                if (by == 10) {
                                    return stringBuilder.toString();
                                }
                                this.undecodedChunk.readerIndex(n);
                                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                            }
                            if (by == 10) {
                                return stringBuilder.toString();
                            }
                            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                            return stringBuilder.toString();
                        }
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private String readDelimiter(String string) {
        HttpPostBodyUtil.SeekAheadOptimize seekAheadOptimize;
        try {
            seekAheadOptimize = new HttpPostBodyUtil.SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil.SeekAheadNoBackArrayException seekAheadNoBackArrayException) {
            return this.readDelimiterStandard(string);
        }
        int n = this.undecodedChunk.readerIndex();
        int n2 = string.length();
        try {
            byte by;
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i = 0; seekAheadOptimize.pos < seekAheadOptimize.limit && i < n2; ++i) {
                if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == string.charAt(i)) {
                    stringBuilder.append((char)by);
                    continue;
                }
                this.undecodedChunk.readerIndex(n);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            if (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 13) {
                    if (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                        if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                            seekAheadOptimize.setReadPosition(0);
                            return stringBuilder.toString();
                        }
                        this.undecodedChunk.readerIndex(n);
                        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                    }
                    this.undecodedChunk.readerIndex(n);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                if (by == 10) {
                    seekAheadOptimize.setReadPosition(0);
                    return stringBuilder.toString();
                }
                if (by == 45) {
                    stringBuilder.append('-');
                    if (seekAheadOptimize.pos < seekAheadOptimize.limit && (by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 45) {
                        stringBuilder.append('-');
                        if (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                            if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 13) {
                                if (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                                    if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                                        seekAheadOptimize.setReadPosition(0);
                                        return stringBuilder.toString();
                                    }
                                    this.undecodedChunk.readerIndex(n);
                                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                                }
                                this.undecodedChunk.readerIndex(n);
                                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                            }
                            if (by == 10) {
                                seekAheadOptimize.setReadPosition(0);
                                return stringBuilder.toString();
                            }
                            seekAheadOptimize.setReadPosition(1);
                            return stringBuilder.toString();
                        }
                        seekAheadOptimize.setReadPosition(0);
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private void readFileUploadByteMultipartStandard(String string) {
        int n = this.undecodedChunk.readerIndex();
        boolean bl = true;
        int n2 = 0;
        int n3 = this.undecodedChunk.readerIndex();
        boolean bl2 = false;
        while (this.undecodedChunk.isReadable()) {
            byte by = this.undecodedChunk.readByte();
            if (bl) {
                if (by == string.codePointAt(n2)) {
                    if (string.length() != ++n2) continue;
                    bl2 = true;
                    break;
                }
                bl = false;
                n2 = 0;
                if (by == 13) {
                    if (!this.undecodedChunk.isReadable()) continue;
                    by = this.undecodedChunk.readByte();
                    if (by == 10) {
                        bl = true;
                        n2 = 0;
                        n3 = this.undecodedChunk.readerIndex() - 2;
                        continue;
                    }
                    n3 = this.undecodedChunk.readerIndex() - 1;
                    this.undecodedChunk.readerIndex(n3);
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                n3 = this.undecodedChunk.readerIndex();
                continue;
            }
            if (by == 13) {
                if (!this.undecodedChunk.isReadable()) continue;
                by = this.undecodedChunk.readByte();
                if (by == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = this.undecodedChunk.readerIndex() - 2;
                    continue;
                }
                n3 = this.undecodedChunk.readerIndex() - 1;
                this.undecodedChunk.readerIndex(n3);
                continue;
            }
            if (by == 10) {
                bl = true;
                n2 = 0;
                n3 = this.undecodedChunk.readerIndex() - 1;
                continue;
            }
            n3 = this.undecodedChunk.readerIndex();
        }
        ByteBuf byteBuf = this.undecodedChunk.copy(n, n3 - n);
        if (bl2) {
            try {
                this.currentFileUpload.addContent(byteBuf, true);
                this.undecodedChunk.readerIndex(n3);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        } else {
            try {
                this.currentFileUpload.addContent(byteBuf, false);
                this.undecodedChunk.readerIndex(n3);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        }
    }

    private void readFileUploadByteMultipart(String string) {
        HttpPostBodyUtil.SeekAheadOptimize seekAheadOptimize;
        try {
            seekAheadOptimize = new HttpPostBodyUtil.SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil.SeekAheadNoBackArrayException seekAheadNoBackArrayException) {
            this.readFileUploadByteMultipartStandard(string);
            return;
        }
        int n = this.undecodedChunk.readerIndex();
        boolean bl = true;
        int n2 = 0;
        int n3 = seekAheadOptimize.pos;
        boolean bl2 = false;
        while (seekAheadOptimize.pos < seekAheadOptimize.limit) {
            byte by = seekAheadOptimize.bytes[seekAheadOptimize.pos++];
            if (bl) {
                if (by == string.codePointAt(n2)) {
                    if (string.length() != ++n2) continue;
                    bl2 = true;
                    break;
                }
                bl = false;
                n2 = 0;
                if (by == 13) {
                    if (seekAheadOptimize.pos >= seekAheadOptimize.limit) continue;
                    if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                        bl = true;
                        n2 = 0;
                        n3 = seekAheadOptimize.pos - 2;
                        continue;
                    }
                    n3 = --seekAheadOptimize.pos;
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = seekAheadOptimize.pos - 1;
                    continue;
                }
                n3 = seekAheadOptimize.pos;
                continue;
            }
            if (by == 13) {
                if (seekAheadOptimize.pos >= seekAheadOptimize.limit) continue;
                if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = seekAheadOptimize.pos - 2;
                    continue;
                }
                n3 = --seekAheadOptimize.pos;
                continue;
            }
            if (by == 10) {
                bl = true;
                n2 = 0;
                n3 = seekAheadOptimize.pos - 1;
                continue;
            }
            n3 = seekAheadOptimize.pos;
        }
        int n4 = seekAheadOptimize.getReadPosition(n3);
        ByteBuf byteBuf = this.undecodedChunk.copy(n, n4 - n);
        if (bl2) {
            try {
                this.currentFileUpload.addContent(byteBuf, true);
                this.undecodedChunk.readerIndex(n4);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        } else {
            try {
                this.currentFileUpload.addContent(byteBuf, false);
                this.undecodedChunk.readerIndex(n4);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
        }
    }

    private void loadFieldMultipartStandard(String string) {
        int n = this.undecodedChunk.readerIndex();
        try {
            boolean bl = true;
            int n2 = 0;
            int n3 = this.undecodedChunk.readerIndex();
            boolean bl2 = false;
            while (this.undecodedChunk.isReadable()) {
                byte by = this.undecodedChunk.readByte();
                if (bl) {
                    if (by == string.codePointAt(n2)) {
                        if (string.length() != ++n2) continue;
                        bl2 = true;
                        break;
                    }
                    bl = false;
                    n2 = 0;
                    if (by == 13) {
                        if (this.undecodedChunk.isReadable()) {
                            by = this.undecodedChunk.readByte();
                            if (by == 10) {
                                bl = true;
                                n2 = 0;
                                n3 = this.undecodedChunk.readerIndex() - 2;
                                continue;
                            }
                            n3 = this.undecodedChunk.readerIndex() - 1;
                            this.undecodedChunk.readerIndex(n3);
                            continue;
                        }
                        n3 = this.undecodedChunk.readerIndex() - 1;
                        continue;
                    }
                    if (by == 10) {
                        bl = true;
                        n2 = 0;
                        n3 = this.undecodedChunk.readerIndex() - 1;
                        continue;
                    }
                    n3 = this.undecodedChunk.readerIndex();
                    continue;
                }
                if (by == 13) {
                    if (this.undecodedChunk.isReadable()) {
                        by = this.undecodedChunk.readByte();
                        if (by == 10) {
                            bl = true;
                            n2 = 0;
                            n3 = this.undecodedChunk.readerIndex() - 2;
                            continue;
                        }
                        n3 = this.undecodedChunk.readerIndex() - 1;
                        this.undecodedChunk.readerIndex(n3);
                        continue;
                    }
                    n3 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = this.undecodedChunk.readerIndex() - 1;
                    continue;
                }
                n3 = this.undecodedChunk.readerIndex();
            }
            if (bl2) {
                try {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n, n3 - n), true);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                }
            }
            try {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n, n3 - n), false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            this.undecodedChunk.readerIndex(n3);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            this.undecodedChunk.readerIndex(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
    }

    private void loadFieldMultipart(String string) {
        HttpPostBodyUtil.SeekAheadOptimize seekAheadOptimize;
        try {
            seekAheadOptimize = new HttpPostBodyUtil.SeekAheadOptimize(this.undecodedChunk);
        }
        catch (HttpPostBodyUtil.SeekAheadNoBackArrayException seekAheadNoBackArrayException) {
            this.loadFieldMultipartStandard(string);
            return;
        }
        int n = this.undecodedChunk.readerIndex();
        try {
            boolean bl = true;
            int n2 = 0;
            int n3 = seekAheadOptimize.pos;
            boolean bl2 = false;
            while (seekAheadOptimize.pos < seekAheadOptimize.limit) {
                byte by = seekAheadOptimize.bytes[seekAheadOptimize.pos++];
                if (bl) {
                    if (by == string.codePointAt(n2)) {
                        if (string.length() != ++n2) continue;
                        bl2 = true;
                        break;
                    }
                    bl = false;
                    n2 = 0;
                    if (by == 13) {
                        if (seekAheadOptimize.pos >= seekAheadOptimize.limit) continue;
                        if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                            bl = true;
                            n2 = 0;
                            n3 = seekAheadOptimize.pos - 2;
                            continue;
                        }
                        n3 = --seekAheadOptimize.pos;
                        continue;
                    }
                    if (by == 10) {
                        bl = true;
                        n2 = 0;
                        n3 = seekAheadOptimize.pos - 1;
                        continue;
                    }
                    n3 = seekAheadOptimize.pos;
                    continue;
                }
                if (by == 13) {
                    if (seekAheadOptimize.pos >= seekAheadOptimize.limit) continue;
                    if ((by = seekAheadOptimize.bytes[seekAheadOptimize.pos++]) == 10) {
                        bl = true;
                        n2 = 0;
                        n3 = seekAheadOptimize.pos - 2;
                        continue;
                    }
                    n3 = --seekAheadOptimize.pos;
                    continue;
                }
                if (by == 10) {
                    bl = true;
                    n2 = 0;
                    n3 = seekAheadOptimize.pos - 1;
                    continue;
                }
                n3 = seekAheadOptimize.pos;
            }
            int n4 = seekAheadOptimize.getReadPosition(n3);
            if (bl2) {
                try {
                    this.currentAttribute.addContent(this.undecodedChunk.copy(n, n4 - n), true);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
                }
            }
            try {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n, n4 - n), false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(iOException);
            }
            this.undecodedChunk.readerIndex(n4);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            this.undecodedChunk.readerIndex(n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
    }

    private static String cleanString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                stringBuilder.append(' ');
                continue;
            }
            if (c == ',') {
                stringBuilder.append(' ');
                continue;
            }
            if (c == '=') {
                stringBuilder.append(' ');
                continue;
            }
            if (c == ';') {
                stringBuilder.append(' ');
                continue;
            }
            if (c == '\t') {
                stringBuilder.append(' ');
                continue;
            }
            if (c == '\"') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString().trim();
    }

    private boolean skipOneLine() {
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte by = this.undecodedChunk.readByte();
        if (by == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            by = this.undecodedChunk.readByte();
            if (by == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (by == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String string) {
        int n;
        int n2;
        char c;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n3 = n2 = HttpPostBodyUtil.findNonWhitespace(string, 0); n3 < string.length() && (c = string.charAt(n3)) != ':' && !Character.isWhitespace(c); ++n3) {
        }
        for (n = n3; n < string.length(); ++n) {
            if (string.charAt(n) != ':') continue;
            ++n;
            break;
        }
        int n4 = HttpPostBodyUtil.findNonWhitespace(string, n);
        int n5 = HttpPostBodyUtil.findEndOfString(string);
        arrayList.add(string.substring(n2, n3));
        String string2 = string.substring(n4, n5);
        String[] stringArray = string2.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(string2) : StringUtil.split(string2, ',');
        for (String string3 : stringArray) {
            arrayList.add(string3.trim());
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private static String[] splitMultipartHeaderValues(String string) {
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList(1);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c != '\"') continue;
                bl = false;
                continue;
            }
            if (c == '\"') {
                bl = true;
                continue;
            }
            if (c != ';') continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

