/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordEncoder;
import io.netty.util.internal.StringUtil;

public class DefaultDnsRecordEncoder
implements DnsRecordEncoder {
    protected DefaultDnsRecordEncoder() {
    }

    @Override
    public final void encodeQuestion(DnsQuestion dnsQuestion, ByteBuf byteBuf) throws Exception {
        this.encodeName(dnsQuestion.name(), byteBuf);
        byteBuf.writeShort(dnsQuestion.type().intValue());
        byteBuf.writeShort(dnsQuestion.dnsClass());
    }

    @Override
    public void encodeRecord(DnsRecord dnsRecord, ByteBuf byteBuf) throws Exception {
        if (dnsRecord instanceof DnsQuestion) {
            this.encodeQuestion((DnsQuestion)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsPtrRecord) {
            this.encodePtrRecord((DnsPtrRecord)dnsRecord, byteBuf);
        } else if (dnsRecord instanceof DnsRawRecord) {
            this.encodeRawRecord((DnsRawRecord)dnsRecord, byteBuf);
        } else {
            throw new UnsupportedMessageTypeException(StringUtil.simpleClassName(dnsRecord));
        }
    }

    private void encodePtrRecord(DnsPtrRecord dnsPtrRecord, ByteBuf byteBuf) throws Exception {
        this.encodeName(dnsPtrRecord.name(), byteBuf);
        byteBuf.writeShort(dnsPtrRecord.type().intValue());
        byteBuf.writeShort(dnsPtrRecord.dnsClass());
        byteBuf.writeInt((int)dnsPtrRecord.timeToLive());
        this.encodeName(dnsPtrRecord.hostname(), byteBuf);
    }

    private void encodeRawRecord(DnsRawRecord dnsRawRecord, ByteBuf byteBuf) throws Exception {
        this.encodeName(dnsRawRecord.name(), byteBuf);
        byteBuf.writeShort(dnsRawRecord.type().intValue());
        byteBuf.writeShort(dnsRawRecord.dnsClass());
        byteBuf.writeInt((int)dnsRawRecord.timeToLive());
        ByteBuf byteBuf2 = dnsRawRecord.content();
        int n = byteBuf2.readableBytes();
        byteBuf.writeShort(n);
        byteBuf.writeBytes(byteBuf2, byteBuf2.readerIndex(), n);
    }

    protected void encodeName(String string, ByteBuf byteBuf) throws Exception {
        String string2;
        int n;
        String[] stringArray;
        if (".".equals(string)) {
            byteBuf.writeByte(0);
            return;
        }
        String[] stringArray2 = stringArray = StringUtil.split(string, '.');
        int n2 = stringArray2.length;
        for (int i = 0; i < n2 && (n = (string2 = stringArray2[i]).length()) != 0; ++i) {
            byteBuf.writeByte(n);
            ByteBufUtil.writeAscii(byteBuf, (CharSequence)string2);
        }
        byteBuf.writeByte(0);
    }
}

