/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.util.Map;

public final class AsciiHeadersEncoder {
    private final ByteBuf buf;
    private final SeparatorType separatorType;
    private final NewlineType newlineType;

    public AsciiHeadersEncoder(ByteBuf byteBuf) {
        this(byteBuf, SeparatorType.COLON_SPACE, NewlineType.CRLF);
    }

    public AsciiHeadersEncoder(ByteBuf byteBuf, SeparatorType separatorType, NewlineType newlineType) {
        if (byteBuf == null) {
            throw new NullPointerException("buf");
        }
        if (separatorType == null) {
            throw new NullPointerException("separatorType");
        }
        if (newlineType == null) {
            throw new NullPointerException("newlineType");
        }
        this.buf = byteBuf;
        this.separatorType = separatorType;
        this.newlineType = newlineType;
    }

    public void encode(Map.Entry<CharSequence, CharSequence> entry) {
        CharSequence charSequence = entry.getKey();
        CharSequence charSequence2 = entry.getValue();
        ByteBuf byteBuf = this.buf;
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = n + n2 + 4;
        int n4 = byteBuf.writerIndex();
        byteBuf.ensureWritable(n3);
        AsciiHeadersEncoder.writeAscii(byteBuf, n4, charSequence, n);
        n4 += n;
        switch (this.separatorType) {
            case COLON: {
                byteBuf.setByte(n4++, 58);
                break;
            }
            case COLON_SPACE: {
                byteBuf.setByte(n4++, 58);
                byteBuf.setByte(n4++, 32);
                break;
            }
            default: {
                throw new Error();
            }
        }
        AsciiHeadersEncoder.writeAscii(byteBuf, n4, charSequence2, n2);
        n4 += n2;
        switch (this.newlineType) {
            case LF: {
                byteBuf.setByte(n4++, 10);
                break;
            }
            case CRLF: {
                byteBuf.setByte(n4++, 13);
                byteBuf.setByte(n4++, 10);
                break;
            }
            default: {
                throw new Error();
            }
        }
        byteBuf.writerIndex(n4);
    }

    private static void writeAscii(ByteBuf byteBuf, int n, CharSequence charSequence, int n2) {
        if (charSequence instanceof AsciiString) {
            AsciiHeadersEncoder.writeAsciiString(byteBuf, n, (AsciiString)charSequence, n2);
        } else {
            AsciiHeadersEncoder.writeCharSequence(byteBuf, n, charSequence, n2);
        }
    }

    private static void writeAsciiString(ByteBuf byteBuf, int n, AsciiString asciiString, int n2) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, n, n2);
    }

    private static void writeCharSequence(ByteBuf byteBuf, int n, CharSequence charSequence, int n2) {
        for (int i = 0; i < n2; ++i) {
            byteBuf.setByte(n++, AsciiHeadersEncoder.c2b(charSequence.charAt(i)));
        }
    }

    private static int c2b(char c) {
        return c < '\u0100' ? (int)c : 63;
    }

    public static enum NewlineType {
        LF,
        CRLF;

    }

    public static enum SeparatorType {
        COLON,
        COLON_SPACE;

    }
}

