/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.AbstractEpollStreamChannel;
import io.netty.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.Socket;
import java.net.SocketAddress;

public final class EpollDomainSocketChannel
extends AbstractEpollStreamChannel
implements DomainSocketChannel {
    private final EpollDomainSocketChannelConfig config = new EpollDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public EpollDomainSocketChannel() {
        super(Socket.newSocketDomain(), false);
    }

    @Deprecated
    public EpollDomainSocketChannel(Channel channel, FileDescriptor fileDescriptor) {
        super(channel, new Socket(fileDescriptor.intValue()));
    }

    @Deprecated
    public EpollDomainSocketChannel(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public EpollDomainSocketChannel(Channel channel, Socket socket) {
        super(channel, socket);
    }

    public EpollDomainSocketChannel(Socket socket, boolean bl) {
        super(socket, bl);
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainUnsafe();
    }

    @Override
    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.fd().bind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
    }

    @Override
    public EpollDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) throws Exception {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.local = (DomainSocketAddress)socketAddress2;
            this.remote = (DomainSocketAddress)socketAddress;
            return true;
        }
        return false;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected boolean doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer, int n) throws Exception {
        Object object = channelOutboundBuffer.current();
        if (object instanceof FileDescriptor && Native.sendFd(this.fd().intValue(), ((FileDescriptor)object).intValue()) > 0) {
            channelOutboundBuffer.remove();
            return true;
        }
        return super.doWriteSingle(channelOutboundBuffer, n);
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        if (object instanceof FileDescriptor) {
            return object;
        }
        return super.filterOutboundMessage(object);
    }

    private final class EpollDomainUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollDomainUnsafe() {
        }

        @Override
        void epollInReady() {
            switch (EpollDomainSocketChannel.this.config().getReadMode()) {
                case BYTES: {
                    super.epollInReady();
                    break;
                }
                case FILE_DESCRIPTORS: {
                    this.epollInReadFd();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void epollInReadFd() {
            if (EpollDomainSocketChannel.this.fd().isInputShutdown()) {
                this.clearEpollIn0();
                return;
            }
            EpollDomainSocketChannelConfig epollDomainSocketChannelConfig = EpollDomainSocketChannel.this.config();
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(EpollDomainSocketChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = EpollDomainSocketChannel.this.pipeline();
            epollRecvByteAllocatorHandle.reset(epollDomainSocketChannelConfig);
            this.epollInBefore();
            try {
                block10: while (true) {
                    epollRecvByteAllocatorHandle.lastBytesRead(Native.recvFd(EpollDomainSocketChannel.this.fd().intValue()));
                    switch (epollRecvByteAllocatorHandle.lastBytesRead()) {
                        case 0: {
                            break block10;
                        }
                        case -1: {
                            this.close(this.voidPromise());
                            return;
                        }
                        default: {
                            epollRecvByteAllocatorHandle.incMessagesRead(1);
                            this.readPending = false;
                            channelPipeline.fireChannelRead(new FileDescriptor(epollRecvByteAllocatorHandle.lastBytesRead()));
                            if (epollRecvByteAllocatorHandle.continueReading()) continue block10;
                        }
                    }
                    break;
                }
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
            }
            catch (Throwable throwable) {
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                channelPipeline.fireExceptionCaught(throwable);
            }
            finally {
                this.epollInFinally(epollDomainSocketChannelConfig);
            }
        }
    }
}

