/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.PlatformDependent;

public final class Epoll {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private Epoll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Throwable throwable = null;
        FileDescriptor fileDescriptor = null;
        FileDescriptor fileDescriptor2 = null;
        try {
            fileDescriptor = Native.newEpollCreate();
            fileDescriptor2 = Native.newEventFd();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (Exception exception) {}
            }
            if (fileDescriptor2 != null) {
                try {
                    fileDescriptor2.close();
                }
                catch (Exception exception) {}
            }
        }
        UNAVAILABILITY_CAUSE = throwable != null ? throwable : (PlatformDependent.hasUnsafe() ? null : new IllegalStateException("sun.misc.Unsafe not available"));
    }
}

