/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.UnixChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final int readFlag;
    private final Socket fileDescriptor;
    protected int flags = Native.EPOLLET;
    protected volatile boolean active;

    AbstractEpollChannel(Socket socket, int n) {
        this(null, socket, n, false);
    }

    AbstractEpollChannel(Channel channel, Socket socket, int n, boolean bl) {
        super(channel);
        this.fileDescriptor = ObjectUtil.checkNotNull(socket, "fd");
        this.readFlag = n;
        this.flags |= n;
        this.active = bl;
    }

    static boolean isSoErrorZero(Socket socket) {
        try {
            return socket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    void setFlag(int n) throws IOException {
        if (!this.isFlagSet(n)) {
            this.flags |= n;
            this.modifyEvents();
        }
    }

    void clearFlag(int n) throws IOException {
        if (this.isFlagSet(n)) {
            this.flags &= ~n;
            this.modifyEvents();
        }
    }

    boolean isFlagSet(int n) {
        return (this.flags & n) != 0;
    }

    @Override
    public final Socket fd() {
        return this.fileDescriptor;
    }

    @Override
    public abstract EpollChannelConfig config();

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        this.active = false;
        try {
            this.doDeregister();
        }
        finally {
            this.fileDescriptor.close();
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    public boolean isOpen() {
        return this.fileDescriptor.isOpen();
    }

    @Override
    protected void doDeregister() throws Exception {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    @Override
    protected final void doBeginRead() throws Exception {
        AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollUnsafe)this.unsafe();
        abstractEpollUnsafe.readPending = true;
        this.setFlag(this.readFlag);
        if (abstractEpollUnsafe.maybeMoreDataToRead) {
            abstractEpollUnsafe.executeEpollInReadyRunnable();
        }
    }

    final void clearEpollIn() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            final AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollUnsafe)this.unsafe();
            if (eventLoop.inEventLoop()) {
                abstractEpollUnsafe.clearEpollIn0();
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!abstractEpollUnsafe.readPending && !AbstractEpollChannel.this.config().isAutoRead()) {
                            abstractEpollUnsafe.clearEpollIn0();
                        }
                    }
                });
            }
        } else {
            this.flags &= ~this.readFlag;
        }
    }

    private void modifyEvents() throws IOException {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    @Override
    protected void doRegister() throws Exception {
        EpollEventLoop epollEventLoop = (EpollEventLoop)this.eventLoop();
        ((AbstractEpollUnsafe)this.unsafe()).epollInReadyRunnablePending = false;
        epollEventLoop.add(this);
    }

    @Override
    protected abstract AbstractEpollUnsafe newUnsafe();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        return this.newDirectBuffer(byteBuf, byteBuf);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.safeRelease(object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n) {
        ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) throws Exception {
        int n;
        int n2 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n = this.fileDescriptor.readAddress(byteBuf.memoryAddress(), n2, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n2, byteBuf.writableBytes());
            n = this.fileDescriptor.read(byteBuffer, byteBuffer.position(), byteBuffer.limit());
        }
        if (n > 0) {
            byteBuf.writerIndex(n2 + n);
        }
        return n;
    }

    protected final int doWriteBytes(ByteBuf byteBuf, int n) throws Exception {
        int n2 = byteBuf.readableBytes();
        int n3 = 0;
        if (byteBuf.hasMemoryAddress()) {
            int n4;
            long l = byteBuf.memoryAddress();
            int n5 = byteBuf.readerIndex();
            int n6 = byteBuf.writerIndex();
            for (int i = n - 1; i >= 0 && (n4 = this.fileDescriptor.writeAddress(l, n5, n6)) > 0; --i) {
                if ((n3 += n4) == n2) {
                    return n3;
                }
                n5 += n4;
            }
        } else {
            int n7;
            int n8;
            int n9;
            ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()) : byteBuf.nioBuffer();
            for (int i = n - 1; i >= 0 && (n9 = this.fileDescriptor.write(byteBuffer, n8 = byteBuffer.position(), n7 = byteBuffer.limit())) > 0; --i) {
                byteBuffer.position(n8 + n9);
                if ((n3 += n9) != n2) continue;
                return n3;
            }
        }
        if (n3 < n2) {
            this.setFlag(Native.EPOLLOUT);
        }
        return n3;
    }

    protected abstract class AbstractEpollUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        boolean epollInReadyRunnablePending;
        private EpollRecvByteAllocatorHandle allocHandle;
        private Runnable epollInReadyRunnable;

        protected AbstractEpollUnsafe() {
        }

        abstract void epollInReady();

        final void epollInBefore() {
            this.maybeMoreDataToRead = false;
        }

        final void epollInFinally(ChannelConfig channelConfig) {
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (!this.readPending && !channelConfig.isAutoRead()) {
                AbstractEpollChannel.this.clearEpollIn();
            } else if (this.readPending && this.maybeMoreDataToRead && !AbstractEpollChannel.this.fd().isInputShutdown()) {
                this.executeEpollInReadyRunnable();
            }
        }

        final void executeEpollInReadyRunnable() {
            if (this.epollInReadyRunnablePending) {
                return;
            }
            this.epollInReadyRunnablePending = true;
            if (this.epollInReadyRunnable == null) {
                this.epollInReadyRunnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractEpollUnsafe.this.epollInReadyRunnablePending = false;
                        AbstractEpollUnsafe.this.epollInReady();
                    }
                };
            }
            AbstractEpollChannel.this.eventLoop().execute(this.epollInReadyRunnable);
        }

        final void epollRdHupReady() {
            this.recvBufAllocHandle().receivedRdHup();
            if (AbstractEpollChannel.this.isActive()) {
                this.epollInReady();
                this.clearEpollRdHup();
            }
            this.shutdownInput();
        }

        private void clearEpollRdHup() {
            try {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLRDHUP);
            }
            catch (IOException iOException) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught(iOException);
                this.close(this.voidPromise());
            }
        }

        void shutdownInput() {
            if (!AbstractEpollChannel.this.fd().isInputShutdown()) {
                if (Boolean.TRUE.equals(AbstractEpollChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                    try {
                        AbstractEpollChannel.this.fd().shutdown(true, false);
                        this.clearEpollIn0();
                        AbstractEpollChannel.this.pipeline().fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                    }
                    catch (IOException iOException) {
                        AbstractEpollChannel.this.pipeline().fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                        this.close(this.voidPromise());
                    }
                } else {
                    this.close(this.voidPromise());
                }
            }
        }

        @Override
        public EpollRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = this.newEpollHandle(super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.Handle handle) {
            return new EpollRecvByteAllocatorHandle(handle, AbstractEpollChannel.this.config());
        }

        @Override
        protected void flush0() {
            if (AbstractEpollChannel.this.isFlagSet(Native.EPOLLOUT)) {
                return;
            }
            super.flush0();
        }

        void epollOutReady() {
            if (AbstractEpollChannel.this.fd().isOutputShutdown()) {
                return;
            }
            super.flush0();
        }

        protected final void clearEpollIn0() {
            assert (AbstractEpollChannel.this.eventLoop().inEventLoop());
            try {
                this.readPending = false;
                AbstractEpollChannel.this.clearFlag(AbstractEpollChannel.this.readFlag);
            }
            catch (IOException iOException) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught(iOException);
                AbstractEpollChannel.this.unsafe().close(AbstractEpollChannel.this.unsafe().voidPromise());
            }
        }
    }
}

