/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER;
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final boolean inbound;
    private final boolean outbound;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private Runnable invokeChannelReadCompleteTask;
    private Runnable invokeReadTask;
    private Runnable invokeChannelWritableStateChangedTask;
    private Runnable invokeFlushTask;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, boolean bl, boolean bl2) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.inbound = bl;
        this.outbound = bl2;
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound());
        return this;
    }

    static void invokeChannelRegistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelRegistered();
                }
            });
        }
    }

    private void invokeChannelRegistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRegistered(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelRegistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound());
        return this;
    }

    static void invokeChannelUnregistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelUnregistered();
                }
            });
        }
    }

    private void invokeChannelUnregistered() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelUnregistered(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelUnregistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound();
        AbstractChannelHandlerContext.invokeChannelActive(abstractChannelHandlerContext);
        return this;
    }

    static void invokeChannelActive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelActive();
                }
            });
        }
    }

    private void invokeChannelActive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelActive(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelActive();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound());
        return this;
    }

    static void invokeChannelInactive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelInactive();
                }
            });
        }
    }

    private void invokeChannelInactive() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelInactive(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelInactive();
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.next, throwable);
        return this;
    }

    static void invokeExceptionCaught(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Throwable throwable) {
        block4: {
            ObjectUtil.checkNotNull(throwable, "cause");
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            } else {
                try {
                    eventExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
                }
            }
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        if (this.invokeHandler()) {
            try {
                this.handler().exceptionCaught(this, throwable);
            }
            catch (Throwable throwable2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                } else if (logger.isWarnEnabled()) {
                    logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                }
            }
        } else {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(), object);
        return this;
    }

    static void invokeUserEventTriggered(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        ObjectUtil.checkNotNull(object, "event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeUserEventTriggered(object);
                }
            });
        }
    }

    private void invokeUserEventTriggered(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).userEventTriggered(this, object);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireUserEventTriggered(object);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(), object);
        return this;
    }

    static void invokeChannelRead(final AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        final Object object2 = abstractChannelHandlerContext.pipeline.touch(ObjectUtil.checkNotNull(object, "msg"), abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object2);
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelRead(object2);
                }
            });
        }
    }

    private void invokeChannelRead(Object object) {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelRead(this, object);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelRead(object);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound());
        return this;
    }

    static void invokeChannelReadComplete(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeChannelReadCompleteTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeChannelReadCompleteTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        abstractChannelHandlerContext.invokeChannelReadComplete();
                    }
                };
            }
            eventExecutor.execute(runnable);
        }
    }

    private void invokeChannelReadComplete() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelReadComplete(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelReadComplete();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound());
        return this;
    }

    static void invokeChannelWritabilityChanged(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeChannelWritableStateChangedTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeChannelWritableStateChangedTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        abstractChannelHandlerContext.invokeChannelWritabilityChanged();
                    }
                };
            }
            eventExecutor.execute(runnable);
        }
    }

    private void invokeChannelWritabilityChanged() {
        if (this.invokeHandler()) {
            try {
                ((ChannelInboundHandler)this.handler()).channelWritabilityChanged(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.fireChannelWritabilityChanged();
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.bind(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.connect(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.connect(socketAddress, socketAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(final SocketAddress socketAddress, final ChannelPromise channelPromise) {
        if (socketAddress == null) {
            throw new NullPointerException("localAddress");
        }
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
                }
            }, channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).bind(this, socketAddress, channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        } else {
            this.bind(socketAddress, channelPromise);
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
                }
            }, channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).connect(this, socketAddress, socketAddress2, channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        } else {
            this.connect(socketAddress, socketAddress2, channelPromise);
        }
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (!this.channel().metadata().hasDisconnect()) {
                abstractChannelHandlerContext.invokeClose(channelPromise);
            } else {
                abstractChannelHandlerContext.invokeDisconnect(channelPromise);
            }
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    if (!AbstractChannelHandlerContext.this.channel().metadata().hasDisconnect()) {
                        abstractChannelHandlerContext.invokeClose(channelPromise);
                    } else {
                        abstractChannelHandlerContext.invokeDisconnect(channelPromise);
                    }
                }
            }, channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).disconnect(this, channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        } else {
            this.disconnect(channelPromise);
        }
    }

    @Override
    public ChannelFuture close(final ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeClose(channelPromise);
                }
            }, channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).close(this, channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        } else {
            this.close(channelPromise);
        }
    }

    @Override
    public ChannelFuture deregister(final ChannelPromise channelPromise) {
        if (!this.validatePromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDeregister(channelPromise);
                }
            }, channelPromise, null);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).deregister(this, channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
            }
        } else {
            this.deregister(channelPromise);
        }
    }

    @Override
    public ChannelHandlerContext read() {
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeReadTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeReadTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        abstractChannelHandlerContext.invokeRead();
                    }
                };
            }
            eventExecutor.execute(runnable);
        }
        return this;
    }

    private void invokeRead() {
        if (this.invokeHandler()) {
            try {
                ((ChannelOutboundHandler)this.handler()).read(this);
            }
            catch (Throwable throwable) {
                this.notifyHandlerException(throwable);
            }
        } else {
            this.read();
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        if (object == null) {
            throw new NullPointerException("msg");
        }
        try {
            if (!this.validatePromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return channelPromise;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    private void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
        } else {
            this.write(object, channelPromise);
        }
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        try {
            ((ChannelOutboundHandler)this.handler()).write(this, object, channelPromise);
        }
        catch (Throwable throwable) {
            AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Runnable runnable = abstractChannelHandlerContext.invokeFlushTask;
            if (runnable == null) {
                abstractChannelHandlerContext.invokeFlushTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        abstractChannelHandlerContext.invokeFlush();
                    }
                };
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, runnable, this.channel().voidPromise(), null);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
        } else {
            this.flush();
        }
    }

    private void invokeFlush0() {
        try {
            ((ChannelOutboundHandler)this.handler()).flush(this);
        }
        catch (Throwable throwable) {
            this.notifyHandlerException(throwable);
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        if (object == null) {
            throw new NullPointerException("msg");
        }
        if (!this.validatePromise(channelPromise, true)) {
            ReferenceCountUtil.release(object);
            return channelPromise;
        }
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    private void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
        } else {
            this.writeAndFlush(object, channelPromise);
        }
    }

    private void write(Object object, boolean bl, ChannelPromise channelPromise) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound();
        Object object2 = this.pipeline.touch(object, abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (bl) {
                abstractChannelHandlerContext.invokeWriteAndFlush(object2, channelPromise);
            } else {
                abstractChannelHandlerContext.invokeWrite(object2, channelPromise);
            }
        } else {
            AbstractWriteTask abstractWriteTask = bl ? WriteAndFlushTask.newInstance(abstractChannelHandlerContext, object2, channelPromise) : WriteTask.newInstance(abstractChannelHandlerContext, object2, channelPromise);
            AbstractChannelHandlerContext.safeExecute(eventExecutor, abstractWriteTask, channelPromise, object2);
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        if (!channelPromise.tryFailure(throwable) && !(channelPromise instanceof VoidChannelPromise) && logger.isWarnEnabled()) {
            logger.warn("Failed to fail the promise because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    private void notifyHandlerException(Throwable throwable) {
        if (AbstractChannelHandlerContext.inExceptionCaught(throwable)) {
            if (logger.isWarnEnabled()) {
                logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", throwable);
            }
            return;
        }
        this.invokeExceptionCaught(throwable);
    }

    private static boolean inExceptionCaught(Throwable throwable) {
        do {
            StackTraceElement[] stackTraceElementArray;
            if ((stackTraceElementArray = throwable.getStackTrace()) == null) continue;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement == null) break;
                if (!"exceptionCaught".equals(stackTraceElement.getMethodName())) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture channelFuture = this.succeededFuture;
        if (channelFuture == null) {
            this.succeededFuture = channelFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean validatePromise(ChannelPromise channelPromise, boolean bl) {
        if (channelPromise == null) {
            throw new NullPointerException("promise");
        }
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return false;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return true;
        }
        if (!bl && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return true;
    }

    private AbstractChannelHandlerContext findContextInbound() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        do {
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        } while (!abstractChannelHandlerContext.inbound);
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        do {
            abstractChannelHandlerContext = abstractChannelHandlerContext.prev;
        } while (!abstractChannelHandlerContext.outbound);
        return abstractChannelHandlerContext;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final void setAddComplete() {
        int n;
        while ((n = this.handlerState) != 3 && !HANDLER_STATE_UPDATER.compareAndSet(this, n, 2)) {
        }
    }

    final void setAddPending() {
        boolean bl = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl);
    }

    private boolean invokeHandler() {
        int n = this.handlerState;
        return n == 2 || !this.ordered && n == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        return this.channel().hasAttr(attributeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object) {
        try {
            eventExecutor.execute(runnable);
        }
        catch (Throwable throwable) {
            try {
                channelPromise.setFailure(throwable);
            }
            finally {
                if (object != null) {
                    ReferenceCountUtil.release(object);
                }
            }
        }
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    static {
        AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(AbstractChannelHandlerContext.class, "handlerState");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
        }
        HANDLER_STATE_UPDATER = atomicIntegerFieldUpdater;
    }

    static final class WriteAndFlushTask
    extends AbstractWriteTask {
        private static final Recycler<WriteAndFlushTask> RECYCLER = new Recycler<WriteAndFlushTask>(){

            @Override
            protected WriteAndFlushTask newObject(Recycler.Handle<WriteAndFlushTask> handle) {
                return new WriteAndFlushTask(handle);
            }
        };

        private static WriteAndFlushTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
            WriteAndFlushTask writeAndFlushTask = RECYCLER.get();
            WriteAndFlushTask.init(writeAndFlushTask, abstractChannelHandlerContext, object, channelPromise);
            return writeAndFlushTask;
        }

        private WriteAndFlushTask(Recycler.Handle<WriteAndFlushTask> handle) {
            super(handle);
        }

        @Override
        public void write(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
            super.write(abstractChannelHandlerContext, object, channelPromise);
            abstractChannelHandlerContext.invokeFlush();
        }
    }

    static final class WriteTask
    extends AbstractWriteTask
    implements SingleThreadEventLoop.NonWakeupRunnable {
        private static final Recycler<WriteTask> RECYCLER = new Recycler<WriteTask>(){

            @Override
            protected WriteTask newObject(Recycler.Handle<WriteTask> handle) {
                return new WriteTask(handle);
            }
        };

        private static WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
            WriteTask writeTask = RECYCLER.get();
            WriteTask.init(writeTask, abstractChannelHandlerContext, object, channelPromise);
            return writeTask;
        }

        private WriteTask(Recycler.Handle<WriteTask> handle) {
            super(handle);
        }
    }

    static abstract class AbstractWriteTask
    implements Runnable {
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("io.netty.transport.estimateSizeOnSubmit", true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("io.netty.transport.writeTaskSizeOverhead", 48);
        private final Recycler.Handle<AbstractWriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        private AbstractWriteTask(Recycler.Handle<? extends AbstractWriteTask> handle) {
            this.handle = handle;
        }

        protected static void init(AbstractWriteTask abstractWriteTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
            abstractWriteTask.ctx = abstractChannelHandlerContext;
            abstractWriteTask.msg = object;
            abstractWriteTask.promise = channelPromise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                ChannelOutboundBuffer channelOutboundBuffer = abstractChannelHandlerContext.channel().unsafe().outboundBuffer();
                if (channelOutboundBuffer != null) {
                    abstractWriteTask.size = abstractChannelHandlerContext.pipeline.estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
                    channelOutboundBuffer.incrementPendingOutboundBytes(abstractWriteTask.size);
                } else {
                    abstractWriteTask.size = 0;
                }
            } else {
                abstractWriteTask.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ChannelOutboundBuffer channelOutboundBuffer = this.ctx.channel().unsafe().outboundBuffer();
                if (ESTIMATE_TASK_SIZE_ON_SUBMIT && channelOutboundBuffer != null) {
                    channelOutboundBuffer.decrementPendingOutboundBytes(this.size);
                }
                this.write(this.ctx, this.msg, this.promise);
            }
            finally {
                this.ctx = null;
                this.msg = null;
                this.promise = null;
                this.handle.recycle(this);
            }
        }

        protected void write(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise) {
            abstractChannelHandlerContext.invokeWrite(object, channelPromise);
        }
    }
}

