/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_TINY_CACHE_SIZE;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    private static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int tinyCacheSize;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PoolThreadLocalCache threadCache = new PoolThreadLocalCache();

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n, int n2, int n3, int n4) {
        this(false, n, n2, n3, n4);
    }

    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4) {
        this(bl, n, n2, n3, n4, DEFAULT_TINY_CACHE_SIZE, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(bl);
        PoolArena poolArena;
        int n8;
        ArrayList<PoolArena.HeapArena> arrayList;
        this.tinyCacheSize = n5;
        this.smallCacheSize = n6;
        this.normalCacheSize = n7;
        int n9 = PooledByteBufAllocator.validateAndCalculateChunkSize(n3, n4);
        if (n < 0) {
            throw new IllegalArgumentException("nHeapArena: " + n + " (expected: >= 0)");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("nDirectArea: " + n2 + " (expected: >= 0)");
        }
        int n10 = PooledByteBufAllocator.validateAndCalculatePageShifts(n3);
        if (n > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(n);
            arrayList = new ArrayList<PoolArena.HeapArena>(this.heapArenas.length);
            for (n8 = 0; n8 < this.heapArenas.length; ++n8) {
                this.heapArenas[n8] = poolArena = new PoolArena.HeapArena(this, n3, n4, n10, n9);
                arrayList.add((PoolArena.HeapArena)poolArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (n2 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray(n2);
            arrayList = new ArrayList(this.directArenas.length);
            for (n8 = 0; n8 < this.directArenas.length; ++n8) {
                this.directArenas[n8] = poolArena = new PoolArena.DirectArena(this, n3, n4, n10, n9);
                arrayList.add((PoolArena.HeapArena)poolArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
    }

    private static <T> PoolArena<T>[] newArenaArray(int n) {
        return new PoolArena[n];
    }

    private static int validateAndCalculatePageShifts(int n) {
        if (n < 4096) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: " + 4096 + ")");
        }
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    private static int validateAndCalculateChunkSize(int n, int n2) {
        if (n2 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n2 + " (expected: 0-14)");
        }
        int n3 = n;
        for (int i = n2; i > 0; --i) {
            if (n3 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n, n2, 0x40000000));
            }
            n3 <<= 1;
        }
        return n3;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n, int n2) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n, n2) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n, n2);
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n, int n2) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n, n2) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n, n2) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n, n2));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static int defaultTinyCacheSize() {
        return DEFAULT_TINY_CACHE_SIZE;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    public int numThreadLocalCaches() {
        PoolArena<Object>[] poolArenaArray;
        PoolArena<Object>[] poolArenaArray2 = poolArenaArray = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (poolArenaArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < poolArenaArray.length; ++i) {
            n += poolArenaArray[i].numThreadCaches.get();
        }
        return n;
    }

    public int tinyCacheSize() {
        return this.tinyCacheSize;
    }

    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    final PoolThreadCache threadCache() {
        return (PoolThreadCache)this.threadCache.get();
    }

    public String dumpStats() {
        int n = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n > 0) {
            for (PoolArena<byte[]> poolArena : this.heapArenas) {
                stringBuilder.append(poolArena);
            }
        }
        int n2 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n2).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n2 > 0) {
            for (PoolArena<ByteBuffer> poolArena : this.directArenas) {
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    static {
        int n = SystemPropertyUtil.getInt("io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n = 8192;
        }
        DEFAULT_PAGE_SIZE = n;
        int n2 = SystemPropertyUtil.getInt("io.netty.allocator.maxOrder", 11);
        Throwable throwable3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n2);
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            n2 = 11;
        }
        DEFAULT_MAX_ORDER = n2;
        Runtime runtime = Runtime.getRuntime();
        int n3 = runtime.availableProcessors() * 2;
        int n4 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.netty.allocator.numHeapArenas", (int)Math.min((long)n3, runtime.maxMemory() / (long)n4 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.netty.allocator.numDirectArenas", (int)Math.min((long)n3, PlatformDependent.maxDirectMemory() / (long)n4 / 2L / 3L)));
        DEFAULT_TINY_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.tinyCacheSize", 512);
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("io.netty.allocator.cacheTrimInterval", 8192);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable3 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable3);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.tinyCacheSize: {}", (Object)DEFAULT_TINY_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
        }
        DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }

    final class PoolThreadLocalCache
    extends FastThreadLocal<PoolThreadCache> {
        PoolThreadLocalCache() {
        }

        @Override
        protected synchronized PoolThreadCache initialValue() {
            PoolArena<byte[]> poolArena = this.leastUsedArena(PooledByteBufAllocator.this.heapArenas);
            PoolArena<ByteBuffer> poolArena2 = this.leastUsedArena(PooledByteBufAllocator.this.directArenas);
            return new PoolThreadCache(poolArena, poolArena2, PooledByteBufAllocator.this.tinyCacheSize, PooledByteBufAllocator.this.smallCacheSize, PooledByteBufAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL);
        }

        @Override
        protected void onRemoval(PoolThreadCache poolThreadCache) {
            poolThreadCache.free();
        }

        private <T> PoolArena<T> leastUsedArena(PoolArena<T>[] poolArenaArray) {
            if (poolArenaArray == null || poolArenaArray.length == 0) {
                return null;
            }
            PoolArena<T> poolArena = poolArenaArray[0];
            for (int i = 1; i < poolArenaArray.length; ++i) {
                PoolArena<T> poolArena2 = poolArenaArray[i];
                if (poolArena2.numThreadCaches.get() >= poolArena.numThreadCaches.get()) continue;
                poolArena = poolArena2;
            }
            return poolArena;
        }
    }
}

