/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.Recycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractPooledDerivedByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.Handle<AbstractPooledDerivedByteBuf<T>> recyclerHandle;
    private AbstractByteBuf buffer;

    AbstractPooledDerivedByteBuf(Recycler.Handle<? extends AbstractPooledDerivedByteBuf<T>> handle) {
        super(0);
        this.recyclerHandle = handle;
    }

    @Override
    public final AbstractByteBuf unwrap() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <U extends AbstractPooledDerivedByteBuf<T>> U init(AbstractByteBuf abstractByteBuf, int n, int n2, int n3) {
        abstractByteBuf.retain();
        this.buffer = abstractByteBuf;
        boolean bl = false;
        try {
            this.maxCapacity(n3);
            this.setIndex(n, n2);
            this.setRefCnt(1);
            AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
            bl = true;
            AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf2 = abstractPooledDerivedByteBuf;
            return (U)abstractPooledDerivedByteBuf2;
        }
        finally {
            if (!bl) {
                this.buffer = null;
                abstractByteBuf.release();
            }
        }
    }

    @Override
    protected final void deallocate() {
        AbstractByteBuf abstractByteBuf = this.unwrap();
        this.recyclerHandle.recycle(this);
        abstractByteBuf.release();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public final ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isReadOnly() {
        return this.unwrap().isReadOnly();
    }

    @Override
    public final boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public final int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n, int n2) {
        return this.nioBuffer(n, n2);
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n = this.readerIndex();
        return this.retainedSlice(n, this.writerIndex() - n);
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        return PooledSlicedByteBuf.newInstance(this, n, n2, n);
    }
}

