/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.addons.systemmonitor;

import de.javasoft.synthetica.addons.systemmonitor.Collector;
import de.javasoft.synthetica.addons.systemmonitor.ModelChangedEvent;
import de.javasoft.synthetica.addons.systemmonitor.ModelChangedListener;
import de.javasoft.synthetica.addons.systemmonitor.RingBuffer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemMonitorModel {
    private ArrayList<String> ids = new ArrayList();
    private HashMap<String, RingBuffer<Float>> buffers = new HashMap();
    private HashMap<String, CollectorThread> collectors = new HashMap();
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, Double> lastValues = new HashMap();
    private HashMap<String, Double> lastMaxValues = new HashMap();
    private HashMap<String, Boolean> visibility = new HashMap();
    private ArrayList<ModelChangedListener> valueListeners = new ArrayList();
    private ArrayList<ModelChangedListener> nonValueListeners = new ArrayList();

    public void addModelChangedListener(ModelChangedListener modelChangedListener, int ... nArray) {
        if (nArray.length == 0) {
            this.nonValueListeners.add(modelChangedListener);
            return;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (n3 == 0 || n3 == 1) {
                this.valueListeners.add(modelChangedListener);
            } else {
                this.nonValueListeners.add(modelChangedListener);
            }
            ++n2;
        }
    }

    public void removeModelChangedListener(ModelChangedListener modelChangedListener) {
        this.valueListeners.remove(modelChangedListener);
        this.nonValueListeners.remove(modelChangedListener);
    }

    protected synchronized void fireModelChangedEvent(ModelChangedEvent<?> modelChangedEvent) {
        int n = modelChangedEvent.getType();
        if (n == 0 || n == 1) {
            for (ModelChangedListener modelChangedListener : this.valueListeners) {
                modelChangedListener.modelChanged(modelChangedEvent);
            }
        } else {
            for (ModelChangedListener modelChangedListener : this.nonValueListeners) {
                modelChangedListener.modelChanged(modelChangedEvent);
            }
        }
    }

    public void addCollector(String string, int n, int n2, Collector collector) {
        this.ids.add(string);
        this.buffers.put(string, new RingBuffer(n));
        this.collectors.put(string, new CollectorThread(string, n2, collector));
        this.lastValues.put(string, collector.getValue());
        this.lastMaxValues.put(string, collector.getMaxValue());
    }

    public void removeCollector(String string) {
        this.ids.remove(string);
        this.buffers.remove(string);
        this.collectors.get(string).interrupt();
        this.lastValues.remove(string);
        this.lastMaxValues.remove(string);
    }

    public void removeAll() {
        HashSet<String> hashSet = new HashSet<String>(this.buffers.keySet());
        for (String string : hashSet) {
            this.removeCollector(string);
        }
    }

    public List<Float> getValues(String string) {
        return this.buffers.get(string).getValues();
    }

    public int getBufferSize(String string) {
        return this.buffers.get(string).getSize();
    }

    public List<String> getIds() {
        return this.ids;
    }

    public double getLastValue(String string) {
        return this.lastValues.get(string);
    }

    public double getLastMaxValue(String string) {
        return this.lastMaxValues.get(string);
    }

    public void setColor(String string, Color color) {
        this.colors.put(string, color);
        this.fireModelChangedEvent(new ModelChangedEvent<Color>(this, 2, string, color));
    }

    public Color getColor(String string) {
        return this.colors.get(string);
    }

    public void setVisible(String string, Boolean bl) {
        this.visibility.put(string, bl);
        this.fireModelChangedEvent(new ModelChangedEvent<Boolean>(this, 3, string, bl));
    }

    public boolean getVisible(String string) {
        return this.visibility.get(string) == null ? true : this.visibility.get(string);
    }

    private class CollectorThread
    extends Thread {
        private String id;
        private int delay;
        private Collector collector;

        public CollectorThread(String string, int n, Collector collector) {
            this.id = string;
            this.delay = n;
            this.collector = collector;
            this.setDaemon(true);
            this.setName(string);
            this.start();
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(this.delay);
                    if (this.isInterrupted()) continue;
                    double d = this.collector.getValue();
                    double d2 = this.collector.getMaxValue();
                    double d3 = (Double)SystemMonitorModel.this.lastValues.get(this.id);
                    double d4 = (Double)SystemMonitorModel.this.lastMaxValues.get(this.id);
                    SystemMonitorModel.this.lastValues.put(this.id, d);
                    SystemMonitorModel.this.lastMaxValues.put(this.id, d2);
                    if (SystemMonitorModel.this.buffers.get(this.id) != null) {
                        ((RingBuffer)SystemMonitorModel.this.buffers.get(this.id)).put(Float.valueOf((float)(d / d2)));
                    }
                    if (SystemMonitorModel.this.valueListeners.size() > 0 && d != d3) {
                        SystemMonitorModel.this.fireModelChangedEvent(new ModelChangedEvent<Double>(SystemMonitorModel.this, 0, this.id, d3));
                    }
                    if (SystemMonitorModel.this.valueListeners.size() <= 0 || d2 == d4) continue;
                    SystemMonitorModel.this.fireModelChangedEvent(new ModelChangedEvent<Double>(SystemMonitorModel.this, 1, this.id, d4));
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
            SystemMonitorModel.this.collectors.remove(this.id);
        }
    }
}

