/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Container;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class LabelStyle
extends StyleWrapper {
    private static LabelStyle instance = new LabelStyle();

    private LabelStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        LabelStyle labelStyle = new LabelStyle();
        labelStyle.setStyle(synthStyle);
        return labelStyle;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        Container container = jComponent.getParent();
        if (container != null && container instanceof JComponent) {
            Color color = null;
            if (((JComponent)container).getUIClassID().equals("StatusBarUI")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.statusBar.label.foreground", jComponent);
            } else if (container instanceof JToolBar) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.toolBar.label.foreground", jComponent);
            }
            if (color != null) {
                return color;
            }
        } else if (colorType == ColorType.TEXT_FOREGROUND && container instanceof CellRendererPane && container.getParent() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)container.getParent();
            Color color = null;
            if (!jComboBox.isEnabled()) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabled.textColor", jComboBox);
            } else if (jComboBox.getForeground() != null && !(jComboBox.getForeground() instanceof ColorUIResource)) {
                color = jComboBox.getForeground();
            } else if (jComboBox.hasFocus()) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.focused.textColor", jComboBox);
            } else if (!jComboBox.isEditable()) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.locked.textColor", jComboBox);
            }
            return color;
        }
        return this.synthStyle.getColor(synthContext, colorType);
    }
}

