/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CountingHandler
extends Handler {
    private AtomicInteger severe = new AtomicInteger(0);
    private AtomicInteger warning = new AtomicInteger(0);

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (Level.SEVERE.equals(logRecord.getLevel())) {
            this.severe.incrementAndGet();
        } else if (Level.WARNING.equals(logRecord.getLevel())) {
            this.warning.incrementAndGet();
        }
    }

    public int countSevere() {
        return this.severe.get();
    }

    public int countWarnings() {
        return this.warning.get();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

