/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.CountedInputStream;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.delta.MatchInfo;
import de.dal33t.powerfolder.util.delta.PartInfoMatcher;
import de.dal33t.powerfolder.util.delta.RollingAdler32;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class MatchResultWorker
implements Callable<List<MatchInfo>> {
    private final FilePartsRecord record;
    private final Path inFile;
    private final ProgressListener progressListener;

    public MatchResultWorker(FilePartsRecord filePartsRecord, Path path, ProgressListener progressListener) {
        Reject.noNullElements(filePartsRecord, path);
        this.record = filePartsRecord;
        this.inFile = path;
        this.progressListener = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MatchInfo> call() throws Exception {
        CountedInputStream countedInputStream = new CountedInputStream(new BufferedInputStream(Files.newInputStream(this.inFile, new OpenOption[0])));
        FilterInputStream filterInputStream = null;
        try {
            long l = Files.size(this.inFile);
            filterInputStream = new PartInfoMatcher(countedInputStream, new RollingAdler32(this.record.getPartLength()), MessageDigest.getInstance("SHA-256"), this.record.getInfos());
            LinkedList<MatchInfo> linkedList = new LinkedList<MatchInfo>();
            MatchInfo matchInfo = null;
            while ((matchInfo = ((PartInfoMatcher)filterInputStream).nextMatch()) != null) {
                if (this.progressListener != null) {
                    this.progressListener.progressReached(l > 0L ? (double)countedInputStream.getReadBytes() / (double)l : 1.0);
                }
                linkedList.add(matchInfo);
            }
            LinkedList<MatchInfo> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            countedInputStream.close();
            filterInputStream.close();
        }
    }
}

