/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Validate;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.delta.PartInfo;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Checksum;

public final class FilePartsRecordBuilder {
    private final Checksum chksum;
    private final MessageDigest partDigester;
    private final MessageDigest fileDigester;
    private final int partSize;
    private List<PartInfo> parts = new LinkedList<PartInfo>();
    private long processed;
    private int partPos;

    public FilePartsRecordBuilder(Checksum checksum, MessageDigest messageDigest, MessageDigest messageDigest2, int n) {
        Reject.noNullElements(checksum, messageDigest, messageDigest2);
        this.chksum = checksum;
        this.partDigester = messageDigest;
        this.fileDigester = messageDigest2;
        this.partSize = n;
    }

    public void update(byte[] byArray, int n, int n2) {
        Validate.notNull(byArray);
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Invalid parameters!");
        }
        this.processed += (long)n2;
        this.fileDigester.update(byArray, n, n2);
        while (n2 > 0) {
            if (this.partPos + n2 >= this.partSize) {
                int n3 = this.partSize - this.partPos;
                this.chksum.update(byArray, n, n3);
                this.partDigester.update(byArray, n, n3);
                this.parts.add(new PartInfo(this.parts.size(), this.chksum.getValue(), this.partDigester.digest()));
                this.chksum.reset();
                n += n3;
                n2 -= n3;
                this.partPos = 0;
                continue;
            }
            this.chksum.update(byArray, n, n2);
            this.partDigester.update(byArray, n, n2);
            this.partPos += n2;
            n2 = 0;
        }
    }

    public void update(int n) {
        this.update(new byte[]{(byte)(n & 0xFF)});
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public FilePartsRecord getRecord() {
        try {
            if (this.partPos > 0) {
                for (int i = 0; i < this.partSize - this.partPos; ++i) {
                    this.chksum.update(0);
                    this.partDigester.update((byte)0);
                }
                this.parts.add(new PartInfo(this.parts.size(), this.chksum.getValue(), this.partDigester.digest()));
            }
            FilePartsRecord filePartsRecord = new FilePartsRecord(this.processed, this.parts.toArray(new PartInfo[0]), this.partSize, this.fileDigester.digest());
            return filePartsRecord;
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        this.processed = 0L;
        this.partPos = 0;
        this.chksum.reset();
        this.fileDigester.reset();
        this.partDigester.reset();
        this.parts.clear();
    }
}

